/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.bungeecord;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.bungeecord.BungeeAudience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.platform.facet.FacetAudienceProvider;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.SettingsChangedEvent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BungeeAudiencesImpl
extends FacetAudienceProvider<CommandSender, BungeeAudience>
implements BungeeAudiences {
    private static final Map<String, BungeeAudiences> INSTANCES;
    private final Plugin plugin;
    private final Listener listener;

    static BungeeAudiences instanceFor(@NotNull Plugin plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return INSTANCES.computeIfAbsent(plugin.getDescription().getName(), name -> new BungeeAudiencesImpl(plugin));
    }

    BungeeAudiencesImpl(Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.listener = new Listener();
        this.plugin.getProxy().getPluginManager().registerListener(this.plugin, (net.md_5.bungee.api.plugin.Listener)this.listener);
        CommandSender console = this.plugin.getProxy().getConsole();
        this.addViewer(console);
        this.changeViewer(console, Locale.getDefault());
        for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
            this.addViewer(player);
        }
    }

    @Override
    @NotNull
    public Audience sender(@NotNull CommandSender sender) {
        if (sender instanceof ProxiedPlayer) {
            return this.player((ProxiedPlayer)sender);
        }
        if (this.isConsole(sender)) {
            return this.console();
        }
        return this.createAudience(Collections.singletonList(sender));
    }

    @Override
    @NotNull
    public Audience player(@NotNull ProxiedPlayer player) {
        return this.player(player.getUniqueId());
    }

    @Nullable
    protected UUID hasId(@NotNull CommandSender viewer) {
        if (viewer instanceof ProxiedPlayer) {
            return ((ProxiedPlayer)viewer).getUniqueId();
        }
        return null;
    }

    protected boolean isConsole(@NotNull CommandSender viewer) {
        return ProxyServer.getInstance().getConsole().equals(viewer);
    }

    protected boolean hasPermission(@NotNull CommandSender viewer, @NotNull String permission) {
        return viewer.hasPermission(permission);
    }

    protected boolean isInWorld(@NotNull CommandSender viewer, @NotNull Key world) {
        return false;
    }

    protected boolean isOnServer(@NotNull CommandSender viewer, @NotNull String server) {
        if (viewer instanceof ProxiedPlayer) {
            return ((ProxiedPlayer)viewer).getServer().getInfo().getName().equals(server);
        }
        return false;
    }

    @NotNull
    protected BungeeAudience createAudience(@NotNull Collection<CommandSender> viewers) {
        return new BungeeAudience(viewers);
    }

    public void close() {
        this.plugin.getProxy().getPluginManager().unregisterListener((net.md_5.bungee.api.plugin.Listener)this.listener);
        super.close();
    }

    static {
        Knob.OUT = message -> ProxyServer.getInstance().getLogger().log(Level.INFO, (String)message);
        Knob.ERR = (message, error) -> ProxyServer.getInstance().getLogger().log(Level.WARNING, (String)message, (Throwable)error);
        try {
            Field gsonField = ProxyServer.getInstance().getClass().getDeclaredField("gson");
            gsonField.setAccessible(true);
            Gson gson = (Gson)gsonField.get(ProxyServer.getInstance());
            BungeeComponentSerializer.inject((Gson)gson);
        }
        catch (Throwable error2) {
            Knob.logError((Throwable)error2, (String)"Failed to inject ProxyServer gson", (Object[])new Object[0]);
        }
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }

    public final class Listener
    implements net.md_5.bungee.api.plugin.Listener {
        @EventHandler(priority=-128)
        public void onLogin(PostLoginEvent event) {
            BungeeAudiencesImpl.this.addViewer(event.getPlayer());
        }

        @EventHandler(priority=127)
        public void onDisconnect(PlayerDisconnectEvent event) {
            BungeeAudiencesImpl.this.removeViewer(event.getPlayer());
        }

        @EventHandler(priority=127)
        public void onSettingsChanged(SettingsChangedEvent event) {
            BungeeAudiencesImpl.this.changeViewer(event.getPlayer(), event.getPlayer().getLocale());
        }
    }
}

