/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.platform.fabric.impl.accessor.ComponentSerializerAccess;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2178;

public final class ComponentArgumentType
implements ArgumentType<Component> {
    private static final ComponentArgumentType INSTANCE = new ComponentArgumentType();
    private static final Set<String> EXAMPLES = ImmutableSet.of((Object)"\"Hello world!\"", (Object)"[\"Message\", {\"text\": \"example\", \"color\": \"#aabbcc\"}]");

    public static ComponentArgumentType component() {
        return INSTANCE;
    }

    public static Component component(CommandContext<?> ctx, String key) {
        return (Component)ctx.getArgument(key, Component.class);
    }

    private ComponentArgumentType() {
    }

    public Component parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
        Component component;
        JsonReader json = new JsonReader((Reader)new StringReader(reader.getRemaining()));
        try {
            Component ret = (Component)ComponentSerializerAccess.getGSON().fromJson(json, Component.class);
            reader.setCursor(reader.getCursor() + ComponentSerializerAccess.getPos(json));
            component = ret;
        }
        catch (Throwable ret) {
            try {
                try {
                    json.close();
                }
                catch (Throwable throwable) {
                    ret.addSuppressed(throwable);
                }
                throw ret;
            }
            catch (JsonParseException | IOException ex) {
                String message = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                throw class_2178.field_9842.createWithContext((ImmutableStringReader)reader, (Object)message);
            }
        }
        json.close();
        return component;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

