/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.GameEnums;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBossBarListener<T extends class_1259>
implements BossBar.Listener {
    private final FabricAudiences controller;
    protected final Map<BossBar, T> bars = new IdentityHashMap<BossBar, T>();

    protected AbstractBossBarListener(FabricAudiences controller) {
        this.controller = controller;
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        if (!oldName.equals(newName)) {
            this.minecraft(bar).method_5413(this.controller.toNative(newName));
        }
    }

    public void bossBarProgressChanged(@NonNull BossBar bar, float oldPercent, float newPercent) {
        if (oldPercent != newPercent) {
            this.minecraft(bar).method_5408(newPercent);
        }
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        if (oldColor != newColor) {
            this.minecraft(bar).method_5416(GameEnums.BOSS_BAR_COLOR.toMinecraft(newColor));
        }
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        if (oldOverlay != newOverlay) {
            this.minecraft(bar).method_5409(GameEnums.BOSS_BAR_OVERLAY.toMinecraft(newOverlay));
        }
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded) {
        AbstractBossBarListener.updateFlags(this.minecraft(bar), bar.flags());
    }

    private static void updateFlags(@NonNull class_1259 bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flags) {
        bar.method_5411(flags.contains(BossBar.Flag.CREATE_WORLD_FOG));
        bar.method_5406(flags.contains(BossBar.Flag.DARKEN_SCREEN));
        bar.method_5410(flags.contains(BossBar.Flag.PLAY_BOSS_MUSIC));
    }

    private T minecraft(@NonNull BossBar bar) {
        @Nullable class_1259 mc = (class_1259)this.bars.get(bar);
        if (mc == null) {
            throw new IllegalArgumentException("Unknown boss bar instance " + bar);
        }
        return (T)mc;
    }

    protected abstract T newBar(@NonNull class_2561 var1, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull class_1259.class_1260 var2, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull class_1259.class_1261 var3, float var4);

    protected T minecraftCreating(@NonNull BossBar bar) {
        return (T)this.bars.computeIfAbsent(bar, key -> {
            T ret = this.newBar(this.controller.toNative(key.name()), GameEnums.BOSS_BAR_COLOR.toMinecraft(key.color()), GameEnums.BOSS_BAR_OVERLAY.toMinecraft(key.overlay()), key.progress());
            AbstractBossBarListener.updateFlags(ret, key.flags());
            key.addListener((BossBar.Listener)this);
            return ret;
        });
    }
}

