/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import ca.stellardrift.colonel.api.ServerArgumentType;
import io.netty.channel.Channel;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.fabric.ComponentArgumentType;
import net.kyori.adventure.platform.fabric.KeyArgumentType;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.ComponentArgumentTypeSerializer;
import net.kyori.adventure.platform.fabric.impl.NBTLegacyHoverEventSerializer;
import net.kyori.adventure.platform.fabric.impl.accessor.ConnectionAccess;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.FriendlyByteBufBridge;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.minecraft.class_2178;
import net.minecraft.class_2232;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AdventureCommon
implements ModInitializer {
    public static final ComponentFlattener FLATTENER;
    public static final PlainComponentSerializer PLAIN;
    public static final GsonComponentSerializer GSON;
    private static final Pattern LOCALIZATION_PATTERN;

    static class_2960 res(@NonNull String value) {
        return new class_2960("adventure", value);
    }

    public void onInitialize() {
        if (FabricLoader.getInstance().isModLoaded("colonel")) {
            ServerArgumentType.builder((class_2960)AdventureCommon.res("component")).type(ComponentArgumentType.class).serializer((class_2314)new ComponentArgumentTypeSerializer()).fallbackProvider(arg -> class_2178.method_9281()).fallbackSuggestions(null).register();
            ServerArgumentType.builder((class_2960)AdventureCommon.res("key")).type(KeyArgumentType.class).serializer((class_2314)new class_2319(KeyArgumentType::key)).fallbackProvider(arg -> class_2232.method_9441()).fallbackSuggestions(null).register();
        } else {
            class_2316.method_10017((String)"adventure:component", ComponentArgumentType.class, (class_2314)new ComponentArgumentTypeSerializer());
            class_2316.method_10017((String)"adventure:key", KeyArgumentType.class, (class_2314)new class_2319(KeyArgumentType::key));
        }
        PlayerLocales.CHANGED_EVENT.register((player, locale) -> {
            Channel channel = ((ConnectionAccess)player.field_13987.method_2872()).getChannel();
            channel.attr(FriendlyByteBufBridge.CHANNEL_LOCALE).set((Object)locale);
            FabricServerAudiencesImpl.forEachInstance(instance -> instance.bossBars().refreshTitles(player));
        });
    }

    static {
        GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NBTLegacyHoverEventSerializer.INSTANCE).build();
        LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
        ComponentFlattener.Builder flattenerBuilder = (ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            flattenerBuilder.mapper(KeybindComponent.class, keybind -> ((class_2561)class_304.method_1419((String)keybind.keybind()).get()).method_10851());
        }
        flattenerBuilder.complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
            String key = translatable.key();
            for (Translator registry : GlobalTranslator.get().sources()) {
                if (!(registry instanceof TranslationRegistry) || !((TranslationRegistry)registry).contains(key)) continue;
                consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.getDefault()));
                return;
            }
            @NonNull String translated = class_2477.method_10517().method_4679(key);
            Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
            List args = translatable.args();
            int argPosition = 0;
            int lastIdx = 0;
            while (matcher.find()) {
                int idx;
                if (lastIdx < matcher.start()) {
                    consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
                }
                lastIdx = matcher.end();
                @Nullable String argIdx = matcher.group(1);
                if (argIdx != null) {
                    try {
                        idx = Integer.parseInt(argIdx);
                        if (idx >= args.size()) continue;
                        consumer.accept((Component)args.get(idx));
                    }
                    catch (NumberFormatException idx2) {}
                    continue;
                }
                if ((idx = argPosition++) >= args.size()) continue;
                consumer.accept((Component)args.get(idx));
            }
            if (lastIdx < translated.length()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx)));
            }
        });
        FLATTENER = (ComponentFlattener)flattenerBuilder.build();
        PLAIN = (PlainComponentSerializer)PlainComponentSerializer.builder().flattener(FLATTENER).build();
    }
}

