/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.GameEnums;
import net.kyori.adventure.platform.fabric.impl.client.AdventureBookAccess;
import net.kyori.adventure.platform.fabric.impl.client.BossHealthOverlayBridge;
import net.kyori.adventure.platform.fabric.impl.client.FabricClientAudiencesImpl;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1659;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientAudience
implements Audience {
    private final class_310 client;
    private final FabricClientAudiencesImpl controller;

    public ClientAudience(class_310 client, FabricClientAudiencesImpl renderer) {
        this.client = client;
        this.controller = renderer;
    }

    public void sendMessage(Identity source, @NonNull Component message, @NonNull MessageType type) {
        if (this.client.method_29042(source.uuid())) {
            return;
        }
        class_1659 visibility = this.client.field_1690.field_1877;
        if (type == MessageType.CHAT) {
            if (visibility == class_1659.field_7538) {
                this.client.field_1705.method_1743().method_27147(this.controller.toNative(message));
            }
        } else if (visibility == class_1659.field_7538 || visibility == class_1659.field_7539) {
            this.client.field_1705.method_1743().method_1812(this.controller.toNative(message));
        }
    }

    public void sendActionBar(@NonNull Component message) {
        this.client.field_1705.method_1758(this.controller.toNative(message), false);
    }

    public void showTitle(@NonNull Title title) {
        @Nullable class_2561 titleText = title.title() == Component.empty() ? null : this.controller.toNative(title.title());
        @Nullable class_2561 subtitleText = title.subtitle() == Component.empty() ? null : this.controller.toNative(title.subtitle());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Title.Times times = title.times();
        this.client.field_1705.method_1763(titleText, subtitleText, this.adventure$ticks(times == null ? null : times.fadeIn()), this.adventure$ticks(times == null ? null : times.stay()), this.adventure$ticks(times == null ? null : times.fadeOut()));
    }

    private int adventure$ticks(@Nullable Duration duration) {
        return duration == null || duration.getSeconds() == -1L ? -1 : (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.client.field_1705.method_1763(null, null, -1, -1, -1);
    }

    public void resetTitle() {
        this.client.field_1705.method_1742();
    }

    public void showBossBar(@NonNull BossBar bar) {
        BossHealthOverlayBridge.listener(this.client.field_1705.method_1740(), this.controller).add(bar);
    }

    public void hideBossBar(@NonNull BossBar bar) {
        BossHealthOverlayBridge.listener(this.client.field_1705.method_1740(), this.controller).remove(bar);
    }

    public void playSound(@NonNull Sound sound) {
        class_746 player = this.client.field_1724;
        if (player != null) {
            this.playSound(sound, player.method_23317(), player.method_23318(), player.method_23321());
        } else {
            this.client.method_1483().method_4873((class_1113)new class_1109(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), sound.volume(), sound.pitch(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
        }
    }

    public void playSound(@NonNull Sound sound, double x, double y, double z) {
        this.client.method_1483().method_4873((class_1113)new class_1109(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), sound.volume(), sound.pitch(), false, 0, class_1113.class_1114.field_5476, x, y, z, false));
    }

    public void stopSound(@NonNull SoundStop stop) {
        @Nullable Key sound = stop.sound();
        @Nullable class_2960 soundIdent = sound == null ? null : FabricAudiences.toNative(sound);
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Sound.Source source = stop.source();
        @Nullable class_3419 category = source == null ? null : GameEnums.SOUND_SOURCE.toMinecraft(source);
        this.client.method_1483().method_4875(soundIdent, category);
    }

    public void openBook(@NonNull Book book) {
        this.client.method_1507((class_437)new class_3872((class_3872.class_3931)new AdventureBookAccess(book, this.controller.localeRenderer())));
    }

    public void sendPlayerListHeader(@NonNull Component header) {
        this.client.field_1705.method_1750().method_1925(header == Component.empty() ? null : this.controller.toNative(header));
    }

    public void sendPlayerListFooter(@NonNull Component footer) {
        this.client.field_1705.method_1750().method_1925(footer == Component.empty() ? null : this.controller.toNative(footer));
    }

    public void sendPlayerListHeaderAndFooter(@NonNull Component header, @NonNull Component footer) {
        this.sendPlayerListHeader(header);
        this.sendPlayerListFooter(footer);
    }
}

