/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.mixin;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.LocaleHolderBridge;
import net.kyori.adventure.platform.fabric.impl.accessor.ClientboundTabListPacketAccess;
import net.kyori.adventure.platform.fabric.impl.accessor.ServerboundClientInformationPacketAccess;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.RenderableAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_2803;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements ForwardingAudience.Single,
LocaleHolderBridge,
RenderableAudience,
ServerPlayerBridge {
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    public class_3244 field_13987;
    private @MonotonicNonNull Audience adventure$backing;
    private Locale adventure$locale;
    private final Map<FabricServerAudiencesImpl, Audience> adventure$renderers = new MapMaker().weakKeys().makeMap();
    private class_2561 adventure$tabListHeader = class_2585.field_24366;
    private class_2561 adventure$tabListFooter = class_2585.field_24366;

    public ServerPlayerMixin(class_1937 level, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void applyBacking(CallbackInfo ci) {
        this.adventure$backing = FabricServerAudiences.of(this.field_13995).audience((class_2165)this);
    }

    public @NonNull Audience audience() {
        return this.adventure$backing;
    }

    @Override
    public Audience renderUsing(FabricServerAudiencesImpl controller) {
        return this.adventure$renderers.computeIfAbsent(controller, ctrl -> new ServerPlayerAudience((class_3222)this, (FabricServerAudiencesImpl)ctrl));
    }

    @Override
    public Locale adventure$locale() {
        return this.adventure$locale;
    }

    @Override
    public void bridge$updateTabList(@Nullable class_2561 header, @Nullable class_2561 footer) {
        if (header != null) {
            this.adventure$tabListHeader = header;
        }
        if (footer != null) {
            this.adventure$tabListFooter = footer;
        }
        class_2772 packet = new class_2772();
        ((ClientboundTabListPacketAccess)packet).setHeader(this.adventure$tabListHeader);
        ((ClientboundTabListPacketAccess)packet).setFooter(this.adventure$tabListFooter);
        this.field_13987.method_14364((class_2596)packet);
    }

    @Inject(method={"updateOptions"}, at={@At(value="HEAD")})
    private void adventure$handleLocaleUpdate(class_2803 information, CallbackInfo ci) {
        String language = ((ServerboundClientInformationPacketAccess)information).getLanguage();
        @Nullable Locale locale = LocaleHolderBridge.toLocale(language);
        if (!Objects.equals(this.adventure$locale, locale)) {
            this.adventure$locale = locale;
            ((PlayerLocales.Changed)PlayerLocales.CHANGED_EVENT.invoker()).onLocaleChanged((class_3222)this, locale);
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    private void adventure$copyBossBars(class_3222 old, boolean alive, CallbackInfo ci) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().replacePlayer(old, (class_3222)this));
    }

    @Inject(method={"disconnect"}, at={@At(value="RETURN")})
    private void adventure$removeBossBarsOnDisconnect(CallbackInfo ci) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().unsubscribeFromAll((class_3222)this));
    }
}

