/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.AdventureCommandSourceStack;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommandSourceStackInternal;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.WrappedComponent;
import net.kyori.adventure.platform.fabric.impl.accessor.ComponentSerializerAccess;
import net.kyori.adventure.platform.fabric.impl.server.CommandSourceAudience;
import net.kyori.adventure.platform.fabric.impl.server.RenderableAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerBossBarListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FabricServerAudiencesImpl
implements FabricServerAudiences {
    private static final Set<FabricServerAudiencesImpl> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private final MinecraftServer server;
    private final ComponentRenderer<Locale> renderer;
    final ServerBossBarListener bossBars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachInstance(Consumer<FabricServerAudiencesImpl> actor) {
        Set<FabricServerAudiencesImpl> set = INSTANCES;
        synchronized (set) {
            for (FabricServerAudiencesImpl instance : INSTANCES) {
                actor.accept(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricServerAudiencesImpl(MinecraftServer server, ComponentRenderer<Locale> renderer) {
        this.server = server;
        this.renderer = renderer;
        this.bossBars = new ServerBossBarListener(this);
        Set<FabricServerAudiencesImpl> set = INSTANCES;
        synchronized (set) {
            INSTANCES.add(this);
        }
    }

    public @NonNull Audience all() {
        return Audience.audience((Audience[])new Audience[]{this.console(), this.players()});
    }

    public @NonNull Audience console() {
        return this.audience((class_2165)this.server);
    }

    public @NonNull Audience players() {
        return Audience.audience(this.audiences(this.server.method_3760().method_14571()));
    }

    public @NonNull Audience player(@NonNull UUID playerId) {
        @Nullable class_3222 player = this.server.method_3760().method_14602(playerId);
        return player != null ? this.audience((class_2165)player) : Audience.empty();
    }

    private Iterable<Audience> audiences(Iterable<? extends class_3222> players) {
        return Iterables.transform(players, this::audience);
    }

    public @NonNull Audience permission(@NonNull String permission) {
        return Audience.empty();
    }

    @Override
    public AdventureCommandSourceStack audience(@NonNull class_2168 source) {
        if (!(source instanceof AdventureCommandSourceStackInternal)) {
            throw new IllegalArgumentException("The AdventureCommandSource mixin failed!");
        }
        AdventureCommandSourceStackInternal internal = (AdventureCommandSourceStackInternal)source;
        return internal.adventure$audience(this.audience(internal.adventure$source()), this);
    }

    @Override
    public Audience audience(@NonNull class_2165 source) {
        if (source instanceof RenderableAudience) {
            return ((RenderableAudience)source).renderUsing(this);
        }
        if (source instanceof Audience) {
            return (Audience)source;
        }
        return new CommandSourceAudience(source, this);
    }

    @Override
    public Audience audience(@NonNull Iterable<class_3222> players) {
        return Audience.audience(this.audiences(players));
    }

    public @NonNull Audience world(@NonNull Key worldId) {
        @Nullable class_3218 level = this.server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)FabricAudiences.toNative(Objects.requireNonNull(worldId, "worldId"))));
        if (level != null) {
            return this.audience(level.method_18456());
        }
        return Audience.empty();
    }

    public @NonNull Audience server(@NonNull String serverName) {
        return Audience.empty();
    }

    @Override
    public ComponentFlattener flattener() {
        return AdventureCommon.FLATTENER;
    }

    @Override
    public PlainComponentSerializer plainSerializer() {
        return AdventureCommon.PLAIN;
    }

    @Override
    public @NonNull ComponentRenderer<Locale> localeRenderer() {
        return this.renderer;
    }

    @Override
    public class_2561 toNative(Component adventure) {
        if (adventure == Component.empty()) {
            return class_2585.field_24366;
        }
        return new WrappedComponent(Objects.requireNonNull(adventure, "adventure"), this.renderer);
    }

    @Override
    public Component toAdventure(class_2561 vanilla) {
        if (vanilla instanceof WrappedComponent) {
            return ((WrappedComponent)vanilla).wrapped();
        }
        return (Component)ComponentSerializerAccess.getGSON().fromJson(class_2561.class_2562.method_10868((class_2561)vanilla), Component.class);
    }

    public ServerBossBarListener bossBars() {
        return this.bossBars;
    }

    public void close() {
    }
}

