/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.GameEnums;
import net.kyori.adventure.platform.fabric.impl.accessor.ConnectionAccess;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.FriendlyByteBufBridge;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2596;
import net.minecraft.class_2635;
import net.minecraft.class_2653;
import net.minecraft.class_2660;
import net.minecraft.class_2762;
import net.minecraft.class_2770;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ServerPlayerAudience
implements Audience {
    private final class_3222 player;
    private final FabricServerAudiencesImpl controller;
    static final String BOOK_TITLE = "title";
    static final String BOOK_AUTHOR = "author";
    static final String BOOK_PAGES = "pages";
    static final String BOOK_RESOLVED = "resolved";

    public ServerPlayerAudience(class_3222 player, FabricServerAudiencesImpl controller) {
        this.player = player;
        this.controller = controller;
    }

    void sendPacket(class_2596<?> packet) {
        this.player.field_13987.method_14364(packet);
    }

    public void sendMessage(Identity source, Component text, MessageType type) {
        class_2556 mcType = type == MessageType.CHAT ? class_2556.field_11737 : class_2556.field_11735;
        this.sendPacket((class_2596<?>)new class_2635(this.controller.toNative(text), mcType, source.uuid()));
    }

    public void sendActionBar(@NonNull Component message) {
        this.sendPacket((class_2596<?>)new class_2762(class_2762.class_2763.field_12627, this.controller.toNative(message)));
    }

    public void showBossBar(@NonNull BossBar bar) {
        FabricServerAudiencesImpl.forEachInstance(controller -> {
            if (controller != this.controller) {
                controller.bossBars.unsubscribe(this.player, bar);
            }
        });
        this.controller.bossBars.subscribe(this.player, bar);
    }

    public void hideBossBar(@NonNull BossBar bar) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars.unsubscribe(this.player, bar));
    }

    public void playSound(@NonNull Sound sound) {
        this.sendPacket((class_2596<?>)new class_2660(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), this.player.method_19538(), sound.volume(), sound.pitch()));
    }

    public void playSound(@NonNull Sound sound, double x, double y, double z) {
        this.sendPacket((class_2596<?>)new class_2660(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), new class_243(x, y, z), sound.volume(), sound.pitch()));
    }

    public void stopSound(@NonNull SoundStop stop) {
        @Nullable Key sound = stop.sound();
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Sound.Source src = stop.source();
        @Nullable class_3419 cat = src == null ? null : GameEnums.SOUND_SOURCE.toMinecraft(src);
        this.sendPacket((class_2596<?>)new class_2770(sound == null ? null : FabricAudiences.toNative(sound), cat));
    }

    public void openBook(@NonNull Book book) {
        class_1799 bookStack = new class_1799((class_1935)class_1802.field_8360, 1);
        class_2487 bookTag = bookStack.method_7948();
        bookTag.method_10582(BOOK_TITLE, this.adventure$serialize(book.title()));
        bookTag.method_10582(BOOK_AUTHOR, this.adventure$serialize(book.author()));
        class_2499 pages = new class_2499();
        for (Component page : book.pages()) {
            pages.add((Object)class_2519.method_23256((String)this.adventure$serialize(page)));
        }
        bookTag.method_10566(BOOK_PAGES, (class_2520)pages);
        bookTag.method_10556(BOOK_RESOLVED, true);
        class_1799 previous = this.player.field_7514.method_7391();
        this.sendPacket((class_2596<?>)new class_2653(-2, this.player.field_7514.field_7545, bookStack));
        this.player.method_7315(bookStack, class_1268.field_5808);
        this.sendPacket((class_2596<?>)new class_2653(-2, this.player.field_7514.field_7545, previous));
    }

    private String adventure$serialize(@NonNull Component component) {
        Locale locale = (Locale)((ConnectionAccess)this.player.field_13987.method_2872()).getChannel().attr(FriendlyByteBufBridge.CHANNEL_LOCALE).get();
        return (String)FabricAudiences.gsonSerializer().serialize(this.controller.localeRenderer().render(component, (Object)(locale == null ? Locale.getDefault() : locale)));
    }

    public void showTitle(@NonNull Title title) {
        Title.Times times;
        if (title.subtitle() != Component.empty()) {
            this.sendPacket((class_2596<?>)new class_2762(class_2762.class_2763.field_12632, this.controller.toNative(title.subtitle())));
        }
        if ((times = title.times()) != null) {
            int fadeIn = ServerPlayerAudience.ticks(times.fadeIn());
            int fadeOut = ServerPlayerAudience.ticks(times.fadeOut());
            int dwell = ServerPlayerAudience.ticks(times.stay());
            if (fadeIn != -1 || fadeOut != -1 || dwell != -1) {
                this.sendPacket((class_2596<?>)new class_2762(fadeIn, dwell, fadeOut));
            }
        }
        if (title.title() != Component.empty()) {
            this.sendPacket((class_2596<?>)new class_2762(class_2762.class_2763.field_12630, this.controller.toNative(title.title())));
        }
    }

    static int ticks(@NonNull Duration duration) {
        return duration.getSeconds() == -1L ? -1 : (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.sendPacket((class_2596<?>)new class_2762(class_2762.class_2763.field_12633, null));
    }

    public void resetTitle() {
        this.sendPacket((class_2596<?>)new class_2762(class_2762.class_2763.field_12628, null));
    }

    public void sendPlayerListHeader(@NonNull Component header) {
        Objects.requireNonNull(header, "header");
        ((ServerPlayerBridge)this.player).bridge$updateTabList(this.controller.toNative(header), null);
    }

    public void sendPlayerListFooter(@NonNull Component footer) {
        Objects.requireNonNull(footer, "footer");
        ((ServerPlayerBridge)this.player).bridge$updateTabList(null, this.controller.toNative(footer));
    }

    public void sendPlayerListHeaderAndFooter(@NonNull Component header, @NonNull Component footer) {
        ((ServerPlayerBridge)this.player).bridge$updateTabList(this.controller.toNative(Objects.requireNonNull(header, "header")), this.controller.toNative(Objects.requireNonNull(footer, "footer")));
    }
}

