/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.spongeapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.facet.FacetAudienceProvider;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.platform.spongeapi.SpongeAudience;
import net.kyori.adventure.platform.spongeapi.SpongeAudiences;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.block.tileentity.CommandBlock;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.command.source.RconSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.living.humanoid.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;

@Singleton
final class SpongeAudiencesImpl
extends FacetAudienceProvider<MessageReceiver, SpongeAudience>
implements SpongeAudiences {
    private static final Map<String, SpongeAudiences> INSTANCES;
    private final Game game;
    private final EventManager eventManager;
    private final EventListener eventListener;

    static SpongeAudiences instanceFor(@NonNull PluginContainer plugin, @NonNull Game game) {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(game, "game");
        return INSTANCES.computeIfAbsent(plugin.getId(), id -> new SpongeAudiencesImpl(plugin, game));
    }

    @Inject
    SpongeAudiencesImpl(@NonNull PluginContainer plugin, @NonNull Game game) {
        this.game = game;
        this.eventManager = game.getEventManager();
        this.eventListener = new EventListener();
        this.eventManager.registerListeners((Object)plugin, (Object)this.eventListener);
        if (game.isServerAvailable() && game.getState().compareTo((Enum)GameState.POST_INITIALIZATION) > 0) {
            this.addViewer(game.getServer().getConsole());
            for (Player player : game.getServer().getOnlinePlayers()) {
                this.addViewer(player);
            }
        }
    }

    @Override
    public @NonNull Audience receiver(@NonNull MessageReceiver receiver) {
        if (receiver instanceof Player) {
            return this.player((Player)receiver);
        }
        if (receiver instanceof ConsoleSource || receiver instanceof RconSource && ((RconSource)receiver).getLoggedIn()) {
            return this.console();
        }
        if (receiver instanceof World) {
            return this.world(Key.key((String)((World)receiver).getName()));
        }
        if (receiver instanceof ProxySource) {
            return this.receiver((MessageReceiver)((ProxySource)receiver).getOriginalSource());
        }
        if (receiver instanceof CommandBlock) {
            return Audience.empty();
        }
        return new SpongeAudience(Collections.singletonList(receiver));
    }

    @Override
    public @NonNull Audience player(@NonNull Player player) {
        return this.player(player.getUniqueId());
    }

    protected @Nullable UUID hasId(@NonNull MessageReceiver viewer) {
        if (viewer instanceof Player) {
            return ((Player)viewer).getUniqueId();
        }
        return null;
    }

    protected boolean isConsole(@NonNull MessageReceiver viewer) {
        return viewer instanceof ConsoleSource;
    }

    protected boolean hasPermission(@NonNull MessageReceiver viewer, @NonNull String permission) {
        if (viewer instanceof Subject) {
            return ((Subject)viewer).hasPermission(permission);
        }
        return false;
    }

    protected boolean isInWorld(@NonNull MessageReceiver viewer, @NonNull Key world) {
        if (viewer instanceof Locatable) {
            return ((Locatable)viewer).getWorld().getName().equals(world.value());
        }
        return false;
    }

    protected boolean isOnServer(@NonNull MessageReceiver viewer, @NonNull String server) {
        return false;
    }

    protected @NonNull SpongeAudience createAudience(@NonNull Collection<MessageReceiver> viewers) {
        return new SpongeAudience(viewers);
    }

    public void close() {
        this.eventManager.unregisterListeners((Object)this.eventListener);
        super.close();
    }

    static {
        Logger logger = LoggerFactory.getLogger(SpongeAudiences.class);
        Knob.OUT = arg_0 -> ((Logger)logger).debug(arg_0);
        Knob.ERR = (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1);
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }

    public final class EventListener {
        @Listener(order=Order.FIRST)
        public void onLogin(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ClientConnectionEvent.Join event) {
            SpongeAudiencesImpl.this.addViewer(event.getTargetEntity());
        }

        @Listener(order=Order.LAST)
        public void onDisconnect(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ClientConnectionEvent.Disconnect event) {
            SpongeAudiencesImpl.this.removeViewer(event.getTargetEntity());
        }

        @Listener(order=Order.LAST)
        public void onChangeSettings(@NonNull PlayerChangeClientSettingsEvent event) {
            SpongeAudiencesImpl.this.changeViewer(event.getTargetEntity(), event.getLocale());
        }

        @Listener
        public void onStart(@NonNull GameStartingServerEvent event) {
            SpongeAudiencesImpl.this.addViewer(SpongeAudiencesImpl.this.game.getServer().getConsole());
        }

        @Listener
        public void onStop(@NonNull GameStoppedServerEvent event) {
            SpongeAudiencesImpl.this.removeViewer(SpongeAudiencesImpl.this.game.getServer().getConsole());
        }
    }
}

