/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.spongeapi;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.platform.facet.FacetBase;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.spongeapi.SpongeComponentSerializer;
import net.kyori.adventure.util.Index;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.world.Locatable;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;

class SpongeFacet<V>
extends FacetBase<V> {
    protected SpongeFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    public <K, S extends CatalogType> @Nullable S sponge(@NonNull Class<S> spongeType, @NonNull K value, @NonNull Index<String, K> elements) {
        return (S)Sponge.getRegistry().getType(spongeType, (String)elements.key(Objects.requireNonNull(value, "value"))).orElseGet(() -> {
            Knob.logUnsupported((Object)((Object)this), (Object)value);
            return null;
        });
    }

    public <S extends CatalogType> @Nullable S sponge(@NonNull Class<S> spongeType, @NonNull Key identifier) {
        return (S)Sponge.getRegistry().getType(spongeType, Objects.requireNonNull(identifier, "Identifier must be non-null").asString()).orElseGet(() -> {
            Knob.logUnsupported((Object)((Object)this), (Object)identifier);
            return null;
        });
    }

    static class TabList
    extends Message<Player>
    implements Facet.TabList<Player, Text> {
        TabList() {
            super(Player.class);
        }

        public void send(Player viewer, @Nullable Text header, @Nullable Text footer) {
            if (header != null && footer != null) {
                viewer.getTabList().setHeaderAndFooter(header, footer);
            } else if (header != null) {
                viewer.getTabList().setHeader(header);
            } else if (footer != null) {
                viewer.getTabList().setFooter(footer);
            }
        }
    }

    static class ViaHook
    implements Function<Player, UserConnection> {
        ViaHook() {
        }

        @Override
        public UserConnection apply(@NonNull Player player) {
            return Via.getManager().getConnection(player.getUniqueId());
        }
    }

    static class BossBar
    extends Message<Player>
    implements Facet.BossBar<Player> {
        private final ServerBossBar bar = ServerBossBar.builder().name(Text.of()).color(BossBarColors.PINK).overlay(BossBarOverlays.PROGRESS).visible(false).build();

        protected BossBar(@NonNull Collection<Player> viewers) {
            super(Player.class);
            this.bar.addPlayers(viewers);
        }

        public void bossBarInitialized(@NonNull net.kyori.adventure.bossbar.BossBar bar) {
            super.bossBarInitialized(bar);
            this.bar.setVisible(true);
        }

        public void bossBarNameChanged(@NonNull net.kyori.adventure.bossbar.BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
            if (!this.bar.getPlayers().isEmpty()) {
                this.bar.setName(this.createMessage((Player)this.bar.getPlayers().iterator().next(), newName));
            }
        }

        public void bossBarProgressChanged(@NonNull net.kyori.adventure.bossbar.BossBar bar, float oldPercent, float newPercent) {
            this.bar.setPercent(newPercent);
        }

        public void bossBarColorChanged(@NonNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull BossBar.Color newColor) {
            BossBarColor color = this.sponge(BossBarColor.class, newColor, BossBar.Color.NAMES);
            if (color != null) {
                this.bar.setColor(color);
            }
        }

        public void bossBarOverlayChanged(@NonNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull BossBar.Overlay newOverlay) {
            BossBarOverlay overlay = this.sponge(BossBarOverlay.class, newOverlay, BossBar.Overlay.NAMES);
            if (overlay != null) {
                this.bar.setOverlay(overlay);
            }
        }

        public void bossBarFlagsChanged(@NonNull net.kyori.adventure.bossbar.BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        BossBar.Flag> removedFlags, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        BossBar.Flag> addedFlags) {
            Boolean bossMusic;
            Boolean darkenScreen;
            Boolean fog = this.hasFlag(BossBar.Flag.CREATE_WORLD_FOG, removedFlags, addedFlags);
            if (fog != null) {
                this.bar.setCreateFog(fog.booleanValue());
            }
            if ((darkenScreen = this.hasFlag(BossBar.Flag.DARKEN_SCREEN, removedFlags, addedFlags)) != null) {
                this.bar.setDarkenSky(darkenScreen.booleanValue());
            }
            if ((bossMusic = this.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC, removedFlags, addedFlags)) != null) {
                this.bar.setPlayEndBossMusic(bossMusic.booleanValue());
            }
        }

        private @Nullable Boolean hasFlag(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull BossBar.Flag flag, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        BossBar.Flag> removedFlags, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
        BossBar.Flag> addedFlags) {
            if (addedFlags.contains(flag)) {
                return true;
            }
            if (removedFlags.contains(flag)) {
                return false;
            }
            return null;
        }

        public void addViewer(@NonNull Player viewer) {
            this.bar.addPlayer(viewer);
        }

        public void removeViewer(@NonNull Player viewer) {
            this.bar.removePlayer(viewer);
        }

        public boolean isEmpty() {
            return !this.bar.isVisible() || this.bar.getPlayers().isEmpty();
        }

        public void close() {
            this.bar.removePlayers(this.bar.getPlayers());
        }
    }

    static class BossBarBuilder
    extends SpongeFacet<Player>
    implements Facet.BossBar.Builder<Player, BossBar> {
        protected BossBarBuilder() {
            super(Player.class);
        }

        public @NonNull BossBar createBossBar(@NonNull Collection<Player> viewers) {
            return new BossBar(viewers);
        }
    }

    static class Book
    extends Message<Viewer>
    implements Facet.Book<Viewer, Text, BookView> {
        protected Book() {
            super(Viewer.class);
        }

        public @NonNull BookView createBook(@NonNull Text title, @NonNull Text author, @NonNull Iterable<Text> pages) {
            return BookView.builder().title(title).author(author).addPages((Collection)Lists.newArrayList(pages)).build();
        }

        public void openBook(@NonNull Viewer viewer, @NonNull BookView book) {
            viewer.sendBookView(book);
        }
    }

    static class Sound
    extends Position
    implements Facet.Sound<Viewer, Vector3d> {
        Sound() {
        }

        public void playSound(@NonNull Viewer viewer, @NonNull net.kyori.adventure.sound.Sound sound, @NonNull Vector3d vector) {
            SoundType type = this.type(sound.name());
            SoundCategory category = this.category(sound.source());
            if (type != null && category != null) {
                viewer.playSound(type, category, vector, (double)sound.volume(), (double)sound.pitch());
            } else if (type != null) {
                viewer.playSound(type, vector, (double)sound.volume(), (double)sound.pitch());
            }
        }

        public void stopSound(@NonNull Viewer viewer, @NonNull SoundStop stop) {
            SoundType type = this.type(stop.sound());
            SoundCategory category = this.category(stop.source());
            if (type != null && category != null) {
                viewer.stopSounds(type, category);
            } else if (type != null) {
                viewer.stopSounds(type);
            } else if (category != null) {
                viewer.stopSounds(category);
            } else {
                viewer.stopSounds();
            }
        }

        public @Nullable SoundType type(@Nullable Key sound) {
            return sound == null ? null : this.sponge(SoundType.class, sound);
        }

        public @Nullable SoundCategory category(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Sound.Source source) {
            return source == null ? null : this.sponge(SoundCategory.class, source, Sound.Source.NAMES);
        }
    }

    static class Position
    extends SpongeFacet<Viewer>
    implements Facet.Position<Viewer, Vector3d> {
        protected Position() {
            super(Viewer.class);
        }

        public boolean isApplicable(@NonNull Viewer viewer) {
            return super.isApplicable((Object)viewer) && viewer instanceof Locatable;
        }

        public @Nullable Vector3d createPosition(@NonNull Viewer viewer) {
            if (viewer instanceof Locatable) {
                return ((Locatable)viewer).getLocation().getPosition();
            }
            return null;
        }

        public @NonNull Vector3d createPosition(double x, double y, double z) {
            return new Vector3d(x, y, z);
        }
    }

    static class Title
    extends Message<Viewer>
    implements Facet.Title<Viewer, Text, org.spongepowered.api.text.title.Title> {
        protected Title() {
            super(Viewer.class);
        }

        public @NonNull org.spongepowered.api.text.title.Title createTitle(@Nullable Text title, @Nullable Text subTitle, int inTicks, int stayTicks, int outTicks) {
            Title.Builder builder = org.spongepowered.api.text.title.Title.builder();
            if (title != null) {
                builder.title(title);
            }
            if (subTitle != null) {
                builder.subtitle(subTitle);
            }
            if (inTicks > -1) {
                builder.fadeIn(Integer.valueOf(inTicks));
            }
            if (stayTicks > -1) {
                builder.stay(Integer.valueOf(stayTicks));
            }
            if (outTicks > -1) {
                builder.fadeOut(Integer.valueOf(outTicks));
            }
            return builder.build();
        }

        public void showTitle(@NonNull Viewer viewer, @NonNull org.spongepowered.api.text.title.Title title) {
            viewer.sendTitle(title);
        }

        public void clearTitle(@NonNull Viewer viewer) {
            viewer.clearTitle();
        }

        public void resetTitle(@NonNull Viewer viewer) {
            viewer.resetTitle();
        }
    }

    static class ActionBar
    extends Message<ChatTypeMessageReceiver>
    implements Facet.ActionBar<ChatTypeMessageReceiver, Text> {
        protected ActionBar() {
            super(ChatTypeMessageReceiver.class);
        }

        public void sendMessage(@NonNull ChatTypeMessageReceiver viewer, @NonNull Text message) {
            viewer.sendMessage(ChatTypes.ACTION_BAR, message);
        }
    }

    static class ChatWithType
    extends Message<ChatTypeMessageReceiver>
    implements Facet.Chat<ChatTypeMessageReceiver, Text> {
        protected ChatWithType() {
            super(ChatTypeMessageReceiver.class);
        }

        private @Nullable ChatType type(@NonNull MessageType type) {
            if (type == MessageType.CHAT) {
                return ChatTypes.CHAT;
            }
            if (type == MessageType.SYSTEM) {
                return ChatTypes.SYSTEM;
            }
            Knob.logUnsupported((Object)((Object)this), (Object)type);
            return null;
        }

        public void sendMessage(@NonNull ChatTypeMessageReceiver viewer, @NonNull Identity source, @NonNull Text message, @NonNull MessageType type) {
            ChatType chat = this.type(type);
            if (chat != null) {
                viewer.sendMessage(chat, message);
            }
        }
    }

    static class Chat
    extends Message<MessageReceiver>
    implements Facet.Chat<MessageReceiver, Text> {
        protected Chat() {
            super(MessageReceiver.class);
        }

        public void sendMessage(@NonNull MessageReceiver viewer, @NonNull Identity source, @NonNull Text message, @NonNull MessageType type) {
            viewer.sendMessage(message);
        }
    }

    static class Message<V>
    extends SpongeFacet<V>
    implements Facet.Message<V, Text> {
        protected Message(@Nullable Class<? extends V> viewerClass) {
            super(viewerClass);
        }

        public @NonNull Text createMessage(@NonNull V viewer, @NonNull Component message) {
            return SpongeComponentSerializer.get().serialize(message);
        }
    }
}

