/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.feature.pagination;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.feature.pagination.PaginationBuilder;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@FunctionalInterface
public interface Pagination<T> {
    public static final int WIDTH = 55;
    public static final int RESULTS_PER_PAGE = 6;
    public static final char LINE_CHARACTER = '-';
    public static final Style LINE_STYLE = Style.style((TextColor)NamedTextColor.DARK_GRAY);
    public static final char PREVIOUS_PAGE_BUTTON_CHARACTER = '\u00ab';
    public static final Style PREVIOUS_PAGE_BUTTON_STYLE = Style.style((StyleBuilderApplicable[])new StyleBuilderApplicable[]{NamedTextColor.RED, HoverEvent.showText((Component)Component.text((String)"Previous Page", (TextColor)NamedTextColor.RED))});
    public static final char NEXT_PAGE_BUTTON_CHARACTER = '\u00bb';
    public static final Style NEXT_PAGE_BUTTON_STYLE = Style.style((StyleBuilderApplicable[])new StyleBuilderApplicable[]{NamedTextColor.GREEN, HoverEvent.showText((Component)Component.text((String)"Next Page", (TextColor)NamedTextColor.GREEN))});
    public static final Renderer DEFAULT_RENDERER = new Renderer(){

        public String toString() {
            return "Pagination.DEFAULT_RENDERER";
        }
    };

    @NotNull
    public static Builder builder() {
        return new PaginationBuilder();
    }

    @NotNull
    public List<Component> render(@NotNull Collection<? extends T> var1, int var2);

    public static interface Builder {
        @NotNull
        public Builder width(int var1);

        @NotNull
        public Builder resultsPerPage(@Range(from=0L, to=0x7FFFFFFFL) int var1);

        @NotNull
        public Builder renderer(@NotNull Renderer var1);

        @NotNull
        public Builder line(@NotNull Consumer<CharacterAndStyle> var1);

        @NotNull
        public Builder previousButton(@NotNull Consumer<CharacterAndStyle> var1);

        @NotNull
        public Builder nextButton(@NotNull Consumer<CharacterAndStyle> var1);

        @NotNull
        public <T> Pagination<T> build(@NotNull Component var1, @NotNull Renderer.RowRenderer<T> var2, @NotNull PageCommandFunction var3);

        public static interface CharacterAndStyle {
            @NotNull
            public CharacterAndStyle character(char var1);

            @NotNull
            public CharacterAndStyle style(@NotNull Style var1);
        }
    }

    @FunctionalInterface
    public static interface PageCommandFunction {
        @NotNull
        public String pageCommand(int var1);
    }

    public static interface Renderer {
        public static final Component GRAY_LEFT_ROUND_BRACKET = Component.text((String)"(", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_LEFT_SQUARE_BRACKET = Component.text((String)"[", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_RIGHT_ROUND_BRACKET = Component.text((String)")", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_RIGHT_SQUARE_BRACKET = Component.text((String)"]", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_FORWARD_SLASH = Component.text((String)"/", (TextColor)NamedTextColor.GRAY);

        @NotNull
        default public Component renderEmpty() {
            return Component.text((String)"No results match.", (TextColor)NamedTextColor.GRAY);
        }

        @NotNull
        default public Component renderUnknownPage(int page, int pages) {
            return Component.text((String)("Unknown page selected. " + pages + " total pages."), (TextColor)NamedTextColor.GRAY);
        }

        @NotNull
        default public Component renderHeader(@NotNull Component title, int page, int pages) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(title)).append((Component)Component.space())).append(GRAY_LEFT_ROUND_BRACKET)).append((Component)Component.text((int)page, (TextColor)NamedTextColor.WHITE))).append(GRAY_FORWARD_SLASH)).append((Component)Component.text((int)pages, (TextColor)NamedTextColor.WHITE))).append(GRAY_RIGHT_ROUND_BRACKET)).append((Component)Component.space())).build();
        }

        @NotNull
        default public Component renderPreviousPageButton(char character, @NotNull Style style, @NotNull ClickEvent clickEvent) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(GRAY_LEFT_SQUARE_BRACKET)).append((Component)Component.text((char)character, (Style)style.clickEvent(clickEvent)))).append(GRAY_RIGHT_SQUARE_BRACKET)).append((Component)Component.space())).build();
        }

        @NotNull
        default public Component renderNextPageButton(char character, @NotNull Style style, @NotNull ClickEvent clickEvent) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(GRAY_LEFT_SQUARE_BRACKET)).append((Component)Component.text((char)character, (Style)style.clickEvent(clickEvent)))).append(GRAY_RIGHT_SQUARE_BRACKET)).append((Component)Component.space())).build();
        }

        @FunctionalInterface
        public static interface RowRenderer<T> {
            @NotNull
            public Collection<Component> renderRow(@Nullable T var1, int var2);
        }
    }
}

