/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.kyori.indra.Indra;
import net.kyori.indra.internal.IndraExtensionImpl;
import net.kyori.indra.internal.SonatypeRepositoriesImpl;
import net.kyori.indra.internal.language.LanguageSupport;
import net.kyori.indra.internal.multirelease.IndraMultireleasePlugin;
import net.kyori.indra.repository.SonatypeRepositories;
import net.kyori.mammoth.ProjectPlugin;
import net.kyori.mammoth.Properties;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.api.GeneratorTask;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraPlugin
implements ProjectPlugin {
    private static final String DIFFPLUG_GOOMPH_APT = "com.diffplug.eclipse.apt";
    private static final String[] APT_TASKS = new String[]{"eclipseJdtApt", "eclipseJdt", "eclipseFactorypath"};

    @Nullable
    public GradleVersion minimumGradleVersion() {
        return Indra.MINIMUM_SUPPORTED;
    }

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        plugins.apply(JavaLibraryPlugin.class);
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) >= 0) {
            plugins.apply("de.jjohannes.missing-metadata-guava");
        }
        IndraExtensionImpl indra = (IndraExtensionImpl)Indra.extension(extensions);
        ((BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class)).getArchivesName().set((Object)project.getName().toLowerCase(Locale.ROOT));
        extensions.configure(JavaPluginExtension.class, java -> java.getToolchain().getLanguageVersion().set(indra.javaVersions().actualVersion().map(JavaLanguageVersion::of)));
        this.applyIdeConfigurationOptions(project.getPluginManager(), extensions, tasks);
        tasks.withType(JavaCompile.class).configureEach(task -> {
            CompileOptions options = task.getOptions();
            options.getCompilerArgs().addAll(Arrays.asList("-parameters", "-Xlint:all"));
            options.getCompilerArgumentProviders().add(indra.previewFeatureArgumentProvider());
        });
        tasks.withType(JavaExec.class).configureEach(task -> task.getArgumentProviders().add(indra.previewFeatureArgumentProvider()));
        tasks.withType(Javadoc.class).configureEach(task -> {
            MinimalJavadocOptions minimalOpts = task.getOptions();
            if (minimalOpts instanceof StandardJavadocDocletOptions) {
                StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalOpts;
                final JavadocOptionFileOption enablePreview = options.addBooleanOption("-enable-preview");
                final JavadocOptionFileOption doclintMissing = options.addBooleanOption("Xdoclint:-missing");
                final JavadocOptionFileOption html5 = options.addBooleanOption("html5");
                final JavadocOptionFileOption noModuleDirectories = options.addBooleanOption("-no-module-directories");
                final Property<Boolean> previewFeaturesEnabledProp = indra.javaVersions().previewFeaturesEnabled();
                task.doFirst((Action)new Action<Task>(){

                    public void execute(@NotNull Task t) {
                        int actual = ((JavadocTool)((Javadoc)t).getJavadocTool().get()).getMetadata().getLanguageVersion().asInt();
                        if (actual >= 9) {
                            if (actual < 12) {
                                noModuleDirectories.setValue((Object)true);
                            }
                            if (actual >= 12) {
                                enablePreview.setValue((Object)((Boolean)previewFeaturesEnabledProp.get()));
                            }
                            doclintMissing.setValue((Object)true);
                            html5.setValue((Object)true);
                        }
                    }
                });
            }
        });
        tasks.withType(ProcessResources.class).configureEach(task -> task.setFilteringCharset(LanguageSupport.DEFAULT_ENCODING));
        extensions.configure(JavaPluginExtension.class, extension -> {
            extension.withJavadocJar();
            extension.withSourcesJar();
        });
        tasks.withType(Test.class).configureEach(Test::useJUnitPlatform);
        indra.configurePublications((Action<MavenPublication>)((Action)publication -> {
            if (((Boolean)((Property)Properties.finalized(indra.includeJavaSoftwareComponentInPublications())).get()).booleanValue()) {
                publication.from((SoftwareComponent)project.getComponents().getByName("java"));
            }
        }));
        plugins.apply(IndraMultireleasePlugin.class);
        project.afterEvaluate(p -> {
            extensions.configure(JavaPluginExtension.class, javaPlugin -> {
                Property versionProp = (Property)Properties.finalized(indra.javaVersions().target());
                javaPlugin.setSourceCompatibility(JavaVersion.toVersion((Object)versionProp.get()));
                javaPlugin.setTargetCompatibility(JavaVersion.toVersion((Object)versionProp.get()));
            });
            if (((Boolean)indra.reproducibleBuilds().get()).booleanValue()) {
                tasks.withType(AbstractArchiveTask.class).configureEach(archive -> {
                    archive.setPreserveFileTimestamps(false);
                    archive.setReproducibleFileOrder(true);
                });
            }
            JavaToolchainService toolchains = (JavaToolchainService)extensions.getByType(JavaToolchainService.class);
            SetProperty testWithProp = (SetProperty)Properties.finalized(indra.javaVersions().testWith());
            ((Set)testWithProp.get()).forEach(targetRuntime -> {
                Property<Boolean> strictVersions = indra.javaVersions().strictVersions();
                Provider<Integer> actualVersion = indra.javaVersions().actualVersion();
                TaskProvider versionedTest = tasks.register(Indra.testJava(targetRuntime), Test.class, test -> {
                    test.setDescription("Runs tests on Java " + targetRuntime + " if necessary based on build settings");
                    test.setGroup("verification");
                    test.onlyIf($ -> (Boolean)strictVersions.get() != false && !Objects.equals(targetRuntime, actualVersion.get()));
                    test.getJavaLauncher().set(toolchains.launcherFor(it -> it.getLanguageVersion().set(strictVersions.zip(actualVersion, (strict, actual) -> JavaLanguageVersion.of((int)(strict != false ? targetRuntime : actual))))));
                });
                tasks.named("check").configure(it -> it.dependsOn(new Object[]{versionedTest}));
            });
        });
        this.registerRepositoryExtensions(project.getRepositories());
    }

    private void registerRepositoryExtensions(RepositoryHandler repositories) {
        ((ExtensionAware)repositories).getExtensions().create(SonatypeRepositories.class, "sonatype", SonatypeRepositoriesImpl.class, new Object[]{repositories});
    }

    private void applyIdeConfigurationOptions(PluginManager manager, ExtensionContainer extensions, TaskContainer tasks) {
        manager.withPlugin(DIFFPLUG_GOOMPH_APT, applied -> extensions.configure(EclipseModel.class, eclipse -> {
            for (String task : APT_TASKS) {
                eclipse.synchronizationTasks(new Object[]{tasks.named(task)});
            }
            tasks.named("eclipseFactorypath", GeneratorTask.class, t -> t.doFirst((Action)new CleanFactorypath()));
        }));
    }

    static class CleanFactorypath
    implements Action<Task> {
        CleanFactorypath() {
        }

        public void execute(@NotNull Task arg0) {
            GeneratorTask generator = (GeneratorTask)arg0;
            if (generator.getInputFile().exists()) {
                generator.getInputFile().delete();
            }
        }
    }
}

