/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.multirelease;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.kyori.indra.multirelease.MultireleaseSourceSet;
import net.kyori.indra.multirelease.MultireleaseVariantDetails;
import net.kyori.indra.task.CheckModuleExports;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

class MultireleaseSourceSetImpl
implements MultireleaseSourceSet {
    static final int MINIMUM_MULTIRELEASE_VERSION = 8;
    private final DomainObjectSet<Integer> alternateVersions;
    private final Property<String> moduleName;
    private final Property<Boolean> applyToJavadoc;
    final Set<Action<MultireleaseVariantDetails>> alternateConfigurationActions = new HashSet<Action<MultireleaseVariantDetails>>();
    final Set<Action<? super CheckModuleExports>> exportValidation = new HashSet<Action<? super CheckModuleExports>>();

    @Inject
    public MultireleaseSourceSetImpl(ObjectFactory objects) {
        this.alternateVersions = objects.domainObjectSet(Integer.class);
        this.moduleName = objects.property(String.class);
        this.applyToJavadoc = objects.property(Boolean.class).convention((Object)false);
    }

    @Override
    @NotNull
    public DomainObjectSet<Integer> alternateVersions() {
        return this.alternateVersions;
    }

    @Override
    @NotNull
    public Property<String> moduleName() {
        return this.moduleName;
    }

    @Override
    public void alternateVersions(int ... alternates) {
        for (int alternate : alternates) {
            this.alternateVersions.add((Object)alternate);
        }
    }

    public static String versionName(SourceSet parent, int version) {
        return parent.getTaskName(null, "java" + version);
    }

    @Override
    public void configureVariants(@NotNull Action<MultireleaseVariantDetails> action) {
        this.alternateConfigurationActions.add(Objects.requireNonNull(action, "action"));
    }

    @Override
    public void requireAllPackagesExported() {
        this.requireAllPackagesExported((Action<? super CheckModuleExports>)((Action)task -> {}));
    }

    @Override
    public void requireAllPackagesExported(@NotNull Action<? super CheckModuleExports> action) {
        this.exportValidation.add(action);
    }

    @Override
    public Property<Boolean> applyToJavadoc() {
        return this.applyToJavadoc;
    }
}

