/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.kyori.indra.util.Versioning;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecOperations;

public abstract class JDeps
extends DefaultTask {
    private final List<CommandLineArgumentProvider> argumentProviders = new ArrayList<CommandLineArgumentProvider>();

    @InputFiles
    public abstract ConfigurableFileCollection getModulePath();

    @Input
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getProcessClasses();

    @Input
    @Optional
    public abstract ListProperty<String> getArguments();

    @Nested
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentProviders;
    }

    @Input
    @Optional
    public abstract Property<Integer> getMultireleaseVersion();

    public void argumentProvider(CommandLineArgumentProvider argumentProvider) {
        this.argumentProviders.add(Objects.requireNonNull(argumentProvider, "argumentProvider"));
    }

    @Inject
    protected abstract JavaToolchainService getToolchains();

    @Inject
    protected abstract ExecOperations getExecOps();

    public JDeps() {
        this.getJavaLauncher().convention(this.getToolchains().launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)Versioning.versionNumber(JavaVersion.current())))));
        this.getMultireleaseVersion().finalizeValueOnRead();
    }

    @Internal
    public List<String> getAllArguments() {
        ArrayList<String> args = new ArrayList<String>((Collection)this.getArguments().get());
        for (CommandLineArgumentProvider clap : this.getArgumentProviders()) {
            Iterable provided = clap.asArguments();
            if (provided instanceof Collection) {
                args.addAll((Collection)provided);
                continue;
            }
            for (String arg : provided) {
                args.add(arg);
            }
        }
        return args;
    }

    private File findJDeps() {
        JavaLauncher launcher = (JavaLauncher)this.getJavaLauncher().get();
        File executable = launcher.getExecutablePath().getAsFile();
        int dotIdx = executable.getName().indexOf(46);
        String jdepsFileName = dotIdx != -1 ? "jdeps" + executable.getName().substring(dotIdx) : "jdeps";
        File jdeps = new File(executable.getParentFile(), jdepsFileName);
        if (!jdeps.exists()) {
            throw new InvalidUserDataException("Toolchain of version " + launcher.getMetadata().getLanguageVersion() + " did not have a jdeps executable.");
        }
        return jdeps;
    }

    @TaskAction
    public void execute() {
        File jdeps = this.findJDeps();
        this.getExecOps().exec(spec -> {
            spec.setExecutable((Object)jdeps);
            if (this.getMultireleaseVersion().isPresent()) {
                spec.args(new Object[]{"--multi-release", ((Integer)this.getMultireleaseVersion().get()).toString()});
            }
            spec.args(new Object[]{"--module-path", this.getModulePath().getAsPath()});
            spec.args(this.getAllArguments());
            for (File file : this.getProcessClasses()) {
                spec.args(new Object[]{file.getAbsolutePath()});
            }
        }).assertNormalExitValue();
    }
}

