/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import javax.inject.Inject;
import net.kyori.indra.JavaToolchainVersions;
import net.kyori.indra.util.Versioning;
import net.kyori.mammoth.Properties;
import org.gradle.api.JavaVersion;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.jetbrains.annotations.NotNull;

public class JavaToolchainVersionsImpl
implements JavaToolchainVersions {
    private static final String STRICT_MULTIRELEASE_VERSIONS = "strictMultireleaseVersions";
    private static final String CI = "CI";
    private final Property<Integer> target;
    private final Property<Integer> minimumToolchain;
    private final Property<Boolean> strictVersions;
    private final SetProperty<Integer> testWith;
    private final Property<Boolean> enablePreviewFeatures;
    private final Provider<Integer> actualVersion;

    @Inject
    public JavaToolchainVersionsImpl(ObjectFactory objects, ProviderFactory providers) {
        this.target = objects.property(Integer.class).convention((Object)8);
        this.minimumToolchain = objects.property(Integer.class).convention((Object)11);
        this.strictVersions = objects.property(Boolean.class).convention(Properties.forUseAtConfigurationTime((Provider)providers.gradleProperty(STRICT_MULTIRELEASE_VERSIONS)).orElse(Properties.forUseAtConfigurationTime((Provider)providers.environmentVariable(CI))).map(Boolean::parseBoolean).orElse((Object)false));
        this.testWith = objects.setProperty(Integer.class);
        this.testWith.add(this.target);
        this.enablePreviewFeatures = objects.property(Boolean.class).convention((Object)false);
        this.actualVersion = this.strictVersions.map(strict -> {
            int running = Versioning.versionNumber(JavaVersion.current());
            int minimum = Math.max((Integer)((Property)Properties.finalized(this.minimumToolchain)).get(), (Integer)((Property)Properties.finalized(this.target)).get());
            if (strict.booleanValue() || running < minimum) {
                return minimum;
            }
            return running;
        });
    }

    @Override
    @NotNull
    public Property<Integer> target() {
        return this.target;
    }

    @Override
    public void target(int target) {
        this.target.set((Object)target);
    }

    @Override
    @NotNull
    public Property<Integer> minimumToolchain() {
        return this.minimumToolchain;
    }

    @Override
    public void minimumToolchain(int minimumToolchain) {
        this.minimumToolchain.set((Object)minimumToolchain);
    }

    @Override
    @NotNull
    public Property<Boolean> strictVersions() {
        return this.strictVersions;
    }

    @Override
    public void strictVersions(boolean strictVersions) {
        this.strictVersions.set((Object)strictVersions);
    }

    @Override
    @NotNull
    public SetProperty<Integer> testWith() {
        return this.testWith;
    }

    @Override
    public void testWith(int ... testVersions) {
        for (int version : testVersions) {
            this.testWith.add((Object)version);
        }
    }

    @Override
    @NotNull
    public Property<Boolean> previewFeaturesEnabled() {
        return this.enablePreviewFeatures;
    }

    @Override
    public void previewFeaturesEnabled(boolean previewFeaturesEnabled) {
        this.enablePreviewFeatures.set((Object)previewFeaturesEnabled);
    }

    @Override
    @NotNull
    public Provider<Integer> actualVersion() {
        return this.actualVersion;
    }
}

