/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.multirelease;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.kyori.indra.multirelease.MultireleaseVariantDetails;
import org.gradle.api.tasks.SourceSet;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@Generated(from="MultireleaseVariantDetails", generator="Immutables")
@Immutable
final class MultireleaseVariantDetailsImpl
implements MultireleaseVariantDetails {
    private final SourceSet base;
    private final int targetVersion;
    private final SourceSet variant;

    public MultireleaseVariantDetailsImpl(@NotNull SourceSet base, int targetVersion, @NotNull SourceSet variant) {
        this.base = Objects.requireNonNull(base, "base");
        this.targetVersion = targetVersion;
        this.variant = Objects.requireNonNull(variant, "variant");
    }

    private MultireleaseVariantDetailsImpl(MultireleaseVariantDetailsImpl original, SourceSet base, int targetVersion, SourceSet variant) {
        this.base = base;
        this.targetVersion = targetVersion;
        this.variant = variant;
    }

    @Override
    @NotNull
    public SourceSet base() {
        return this.base;
    }

    @Override
    public int targetVersion() {
        return this.targetVersion;
    }

    @Override
    @NotNull
    public SourceSet variant() {
        return this.variant;
    }

    public final MultireleaseVariantDetailsImpl base(SourceSet value) {
        if (this.base == value) {
            return this;
        }
        SourceSet newValue = Objects.requireNonNull(value, "base");
        return new MultireleaseVariantDetailsImpl(this, newValue, this.targetVersion, this.variant);
    }

    public final MultireleaseVariantDetailsImpl targetVersion(int value) {
        if (this.targetVersion == value) {
            return this;
        }
        return new MultireleaseVariantDetailsImpl(this, this.base, value, this.variant);
    }

    public final MultireleaseVariantDetailsImpl variant(SourceSet value) {
        if (this.variant == value) {
            return this;
        }
        SourceSet newValue = Objects.requireNonNull(value, "variant");
        return new MultireleaseVariantDetailsImpl(this, this.base, this.targetVersion, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultireleaseVariantDetailsImpl && this.equalTo(0, (MultireleaseVariantDetailsImpl)another);
    }

    private boolean equalTo(int synthetic, MultireleaseVariantDetailsImpl another) {
        return this.base.equals(another.base) && this.targetVersion == another.targetVersion && this.variant.equals(another.variant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.base.hashCode();
        h += (h << 5) + this.targetVersion;
        h += (h << 5) + this.variant.hashCode();
        return h;
    }

    public String toString() {
        return "MultireleaseVariantDetails{base=" + this.base + ", targetVersion=" + this.targetVersion + ", variant=" + this.variant + "}";
    }

    public static MultireleaseVariantDetailsImpl copyOf(MultireleaseVariantDetails instance) {
        if (instance instanceof MultireleaseVariantDetailsImpl) {
            return (MultireleaseVariantDetailsImpl)instance;
        }
        return new BuilderImpl().from(instance).build();
    }

    @Generated(from="MultireleaseVariantDetails", generator="Immutables")
    @NotThreadSafe
    static final class BuilderImpl {
        private static final long INIT_BIT_BASE = 1L;
        private static final long INIT_BIT_TARGET_VERSION = 2L;
        private static final long INIT_BIT_VARIANT = 4L;
        private long initBits = 7L;
        @Nullable
        private SourceSet base;
        private int targetVersion;
        @Nullable
        private SourceSet variant;

        BuilderImpl() {
        }

        public final BuilderImpl from(MultireleaseVariantDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.base(instance.base());
            this.targetVersion(instance.targetVersion());
            this.variant(instance.variant());
            return this;
        }

        public final BuilderImpl base(SourceSet base) {
            this.base = Objects.requireNonNull(base, "base");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final BuilderImpl targetVersion(int targetVersion) {
            this.targetVersion = targetVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final BuilderImpl variant(SourceSet variant) {
            this.variant = Objects.requireNonNull(variant, "variant");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public MultireleaseVariantDetailsImpl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MultireleaseVariantDetailsImpl(null, this.base, this.targetVersion, this.variant);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("base");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetVersion");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("variant");
            }
            return "Cannot build MultireleaseVariantDetails, some of required attributes are not set " + attributes;
        }
    }
}

