/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.util;

import net.kyori.indra.git.IndraGitExtension;
import org.eclipse.jgit.lib.Ref;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Versioning {
    public static int versionNumber(@NotNull JavaVersion version) {
        return version.ordinal() + 1;
    }

    public static String versionString(int version) {
        if (version <= 8) {
            return "1." + version;
        }
        return String.valueOf(version);
    }

    public static String versionString(@NotNull JavaVersion version) {
        if (version == JavaVersion.VERSION_1_9) {
            return "9";
        }
        if (version == JavaVersion.VERSION_1_10) {
            return "10";
        }
        return version.toString();
    }

    public static boolean isSnapshot(@NotNull Project project) {
        return project.getVersion().toString().contains("-SNAPSHOT");
    }

    public static boolean isRelease(@NotNull Project project) {
        @Nullable IndraGitExtension git = (IndraGitExtension)project.getExtensions().findByType(IndraGitExtension.class);
        @Nullable Ref tag = git == null ? null : git.headTag();
        return (tag != null || git == null || !git.isPresent()) && !Versioning.isSnapshot(project);
    }

    private Versioning() {
    }
}

