/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModularityDetecter {
    private static final Logger LOGGER = Logging.getLogger(ModularityDetecter.class);
    private static final String MODULE_INFO = "module-info.class";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    private static final String MULTI_RELEASE = "Multi-Release";
    private static final String MULTIRELEASE_PATH_PREFIX = "META-INF/versions/";

    private ModularityDetecter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModule(File library, boolean inferModulePath) {
        Manifest manifest;
        if (!inferModulePath) {
            return false;
        }
        if (library.isFile()) {
            try (ZipFile jf = new ZipFile(library);){
                Manifest manifest2;
                if (jf.getEntry(MODULE_INFO) != null) {
                    boolean bl = true;
                    return bl;
                }
                @Nullable ZipEntry manifestEntry = jf.getEntry(MANIFEST);
                if (manifestEntry == null) return false;
                try (InputStream is = jf.getInputStream(manifestEntry);){
                    manifest2 = new Manifest(is);
                }
                if (manifest2.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME) != null) {
                    boolean bl = true;
                    return bl;
                }
                if (!"true".equals(manifest2.getMainAttributes().getValue(MULTI_RELEASE))) return false;
                boolean bl = jf.stream().anyMatch(entry -> ModularityDetecter.isModuleInfo(entry.getName()));
                return bl;
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to determine module status for {}:", (Object)library, (Object)ex);
                return false;
            }
        }
        if (!library.isDirectory()) return false;
        if (new File(library, MODULE_INFO).isFile()) {
            return true;
        }
        File manifestFile = new File(library, MANIFEST);
        if (!manifestFile.isFile()) return false;
        try (FileInputStream is = new FileInputStream(manifestFile);){
            manifest = new Manifest(is);
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to determine module status for {}:", (Object)library, (Object)ex);
            return false;
        }
        if (manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME) != null) {
            return true;
        }
        if (!"true".equals(manifest.getMainAttributes().getValue(MULTI_RELEASE))) return false;
        File[] variants = new File(library, MULTIRELEASE_PATH_PREFIX).listFiles();
        if (variants == null) return false;
        File[] fileArray = variants;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File variant = fileArray[n2];
            if (new File(variant, MODULE_INFO).exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isModuleInfo(@NotNull String path) {
        return MODULE_INFO.equals(path) || path.startsWith(MULTIRELEASE_PATH_PREFIX) && path.endsWith(MODULE_INFO);
    }
}

