/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class SelfPreferringClassLoader
extends URLClassLoader {
    private final ClassLoader parent;

    public SelfPreferringClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result = this.findLoadedClass(name);
            if (result == null) {
                try {
                    result = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (result == null) {
                return super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        @Nullable URL result = this.findResource(name);
        if (result == null) {
            result = super.getResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        return new Enumeration<URL>(){
            @Nullable
            Enumeration<URL> active;
            @Nullable
            Enumeration<URL> staged;
            {
                this.active = SelfPreferringClassLoader.this.findResources(name);
                this.staged = SelfPreferringClassLoader.this.parent == null ? ClassLoader.getSystemClassLoader().getResources(name) : SelfPreferringClassLoader.this.parent.getResources(name);
            }

            @Nullable
            private Enumeration<URL> nextComponent() {
                if (this.active == null) {
                    return null;
                }
                if (!this.active.hasMoreElements()) {
                    this.active = this.staged;
                    this.staged = null;
                }
                return this.active;
            }

            @Override
            public boolean hasMoreElements() {
                @Nullable Enumeration<URL> component = this.nextComponent();
                return component != null && component.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                @Nullable Enumeration<URL> component = this.nextComponent();
                if (component == null) {
                    throw new NoSuchElementException();
                }
                return component.nextElement();
            }
        };
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

