/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal;

import java.util.Locale;
import javax.inject.Inject;
import net.kyori.indra.repository.SonatypeRepositories;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;

public class SonatypeRepositoriesImpl
implements SonatypeRepositories {
    private final RepositoryHandler repositories;

    @Inject
    public SonatypeRepositoriesImpl(RepositoryHandler repositories) {
        this.repositories = repositories;
    }

    @Override
    public MavenArtifactRepository ossSnapshots() {
        return this.repositories.maven(repo -> {
            repo.setName("sonatypeSnapshots");
            repo.setUrl((Object)"https://oss.sonatype.org/content/repositories/snapshots/");
            repo.mavenContent(MavenRepositoryContentDescriptor::snapshotsOnly);
        });
    }

    @Override
    public MavenArtifactRepository snapshotsOn(int host) {
        return this.repositories.maven(repo -> {
            repo.setName("sonatypeSnapshots");
            repo.setUrl((Object)SonatypeRepositoriesImpl.formatOssHost(host));
            repo.mavenContent(MavenRepositoryContentDescriptor::snapshotsOnly);
        });
    }

    static String formatOssHost(int host) {
        if (host < 1) {
            throw new IllegalArgumentException("Only hosts numbered >= 1 are supported, but " + host + " was provided");
        }
        return String.format(Locale.ROOT, "https://s%02d.oss.sonatype.org/content/repositories/snapshots/", host);
    }
}

