/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.language;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Inject;
import net.kyori.indra.internal.SelfPreferringClassLoader;
import net.kyori.indra.internal.language.LanguageSupport;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

public class KotlinSupport
implements LanguageSupport {
    private static final String KOTLIN_PLUGIN = "org.jetbrains.kotlin.jvm";
    private static final String SENTINEL_CLASS = "org.jetbrains.kotlin.gradle.tasks.KotlinCompile";
    private final JavaToolchainService toolchains;
    private final ThreadLocal<KotlinInvoker> childClass = new ThreadLocal();
    private final Map<Plugin<?>, KotlinInvoker> invokers = new WeakHashMap();

    @Inject
    public KotlinSupport(JavaToolchainService toolchains) {
        this.toolchains = toolchains;
    }

    @Override
    public void registerApplyCallback(@NotNull Project project, @NotNull Action<? super Project> callback) {
        project.getPlugins().withId(KOTLIN_PLUGIN, pl -> {
            Map<Plugin<?>, KotlinInvoker> map = this.invokers;
            synchronized (map) {
                this.childClass.set(this.invokers.computeIfAbsent((Plugin<?>)pl, key -> {
                    try {
                        try {
                            this.getClass().getClassLoader().loadClass(SENTINEL_CLASS);
                            return new KotlinInvoker(this.getClass().getClassLoader());
                        }
                        catch (ClassNotFoundException ex) {
                            SelfPreferringClassLoader classLoader = new SelfPreferringClassLoader(new URL[]{KotlinSupport.class.getProtectionDomain().getCodeSource().getLocation()}, key.getClass().getClassLoader());
                            return new KotlinInvoker(classLoader);
                        }
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new GradleException("Unable to create a Kotlin invoker", (Throwable)ex);
                    }
                }));
            }
            try {
                callback.execute((Object)project);
            }
            finally {
                this.childClass.remove();
            }
        });
    }

    @Override
    public void configureCompileTasks(@NotNull Project project, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
        this.childClass.get().configureCompileTasks(this.toolchains, project.getTasks(), sourceSet, toolchainVersion, bytecodeVersion);
    }

    static final class KotlinInvoker {
        private static final String KOTLIN_SHIM = "net.kyori.indra.internal.language.KotlinShim";
        private final Method configureCompileTasks;

        KotlinInvoker(ClassLoader loader) throws ReflectiveOperationException {
            Class<?> kotlinShim = loader.loadClass(KOTLIN_SHIM);
            this.configureCompileTasks = kotlinShim.getMethod("configureCompileTasks", JavaToolchainService.class, TaskContainer.class, SourceSet.class, Provider.class, Provider.class);
        }

        void configureCompileTasks(JavaToolchainService toolchains, @NotNull TaskContainer tasks, @NotNull SourceSet sourceSet, @NotNull Provider<Integer> toolchainVersion, @NotNull Provider<Integer> bytecodeVersion) {
            try {
                this.configureCompileTasks.invoke(null, toolchains, tasks, sourceSet, toolchainVersion, bytecodeVersion);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new GradleException("Failed to invoke compile task configuration step for Kotlin source set", (Throwable)ex);
            }
        }
    }
}

