/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.multirelease;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.kyori.indra.Indra;
import net.kyori.indra.IndraExtension;
import net.kyori.indra.internal.ModularityDetecter;
import net.kyori.indra.internal.language.GroovySupport;
import net.kyori.indra.internal.language.JavaSupport;
import net.kyori.indra.internal.language.KotlinSupport;
import net.kyori.indra.internal.language.LanguageSupport;
import net.kyori.indra.internal.language.ScalaSupport;
import net.kyori.indra.internal.multirelease.MultireleaseModulePatchArgumentProvider;
import net.kyori.indra.internal.multirelease.MultireleaseSourceSetImpl;
import net.kyori.indra.multirelease.MultireleaseSourceSet;
import net.kyori.indra.multirelease.MultireleaseVariantDetails;
import net.kyori.indra.task.CheckModuleExports;
import net.kyori.indra.task.JDeps;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraMultireleasePlugin
implements ProjectPlugin {
    private static final List<Class<? extends LanguageSupport>> SUPPORTED_LANGUAGES = Collections.unmodifiableList(Arrays.asList(JavaSupport.class, GroovySupport.class, ScalaSupport.class, KotlinSupport.class));
    private static final String MULTI_RELEASE_ATTRIBUTE = "Multi-Release";
    private static final String MULTI_RELEASE_PATH = "META-INF/versions/";
    private static final String CLASSES_VARIANT = "classes";
    private static final String RESOURCES_VARAINT = "resources";
    private static final String ECLIPSE_MODULE_ATTRIBUTE = "module";
    private LanguageSupport[] languageSupports;
    private final ObjectFactory objects;

    @Inject
    public IndraMultireleasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        plugins.withType(JavaBasePlugin.class, $ -> {
            this.languageSupports = this.initLanguageSupports(project, project.getObjects());
            SourceSetContainer sourceSets = (SourceSetContainer)extensions.getByType(SourceSetContainer.class);
            this.configureMultiRelease(project, tasks, project.getDependencies(), sourceSets);
            plugins.withType(JavaPlugin.class, $$ -> this.configureStandardSourceSetMultireleaseActions(project, Indra.extension(extensions), tasks, sourceSets));
            plugins.withType(EclipsePlugin.class, $$ -> {
                EclipseModel eclipse = (EclipseModel)extensions.getByType(EclipseModel.class);
                IndraExtension indra = Indra.extension(extensions);
                this.configureEclipseProjectVersions(project, eclipse, indra, sourceSets);
                this.configureEclipseModulePath(project, eclipse, sourceSets);
            });
        });
    }

    private LanguageSupport[] initLanguageSupports(Project project, ObjectFactory objects) {
        JavaToolchainService toolchains = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        LanguageSupport[] languages = new LanguageSupport[SUPPORTED_LANGUAGES.size()];
        for (int i = 0; i < SUPPORTED_LANGUAGES.size(); ++i) {
            languages[i] = (LanguageSupport)objects.newInstance(SUPPORTED_LANGUAGES.get(i), new Object[]{toolchains});
        }
        return languages;
    }

    private void configureLanguages(Project project, SourceSet set, Provider<Integer> toolchainVersion, Provider<Integer> targetVersion) {
        this.configureLanguages(project, set, toolchainVersion, targetVersion, toolchainVersion, targetVersion);
    }

    private void configureLanguages(Project project, SourceSet set, Provider<Integer> compileToolchainVersion, Provider<Integer> compileTargetVersion, Provider<Integer> docsToolchainVersion, Provider<Integer> docsTargetVersion) {
        for (LanguageSupport lang : this.languageSupports) {
            lang.registerApplyCallback(project, (Action<? super Project>)((Action)p -> {
                lang.configureCompileTasks((Project)p, set, compileToolchainVersion, compileTargetVersion);
                lang.configureDocTasks((Project)p, set, docsToolchainVersion, docsTargetVersion);
            }));
        }
    }

    private void configureMultiRelease(Project project, TaskContainer tasks, DependencyHandler dependencies, SourceSetContainer sourceSets) {
        ConcurrentHashMap.KeySetView alternateNames = ConcurrentHashMap.newKeySet();
        sourceSets.all(parent -> {
            if (alternateNames.contains(parent.getName())) {
                return;
            }
            IndraExtension indra = Indra.extension(project.getExtensions());
            MultireleaseSourceSet multireleaseExtension = (MultireleaseSourceSet)parent.getExtensions().create(MultireleaseSourceSet.class, "multirelease", MultireleaseSourceSetImpl.class, new Object[]{project.getObjects()});
            Provider alternateVersions = project.getProviders().provider(multireleaseExtension::alternateVersions).zip(multireleaseExtension.applyToJavadoc(), (alternates, useAlts) -> useAlts != false ? alternates : Collections.emptySet());
            Provider docsTargetVersion = indra.javaVersions().target().zip(alternateVersions, (base, alternates) -> {
                int actual = base;
                Iterator iterator = alternates.iterator();
                while (iterator.hasNext()) {
                    int version = (Integer)iterator.next();
                    actual = Math.max(version, actual);
                }
                return actual;
            });
            Provider docsRuntimeVersion = indra.javaVersions().actualVersion().zip(alternateVersions, (base, alternates) -> {
                int actual = base;
                Iterator iterator = alternates.iterator();
                while (iterator.hasNext()) {
                    int version = (Integer)iterator.next();
                    actual = Math.max(version, actual);
                }
                return actual;
            });
            this.configureLanguages(project, (SourceSet)parent, indra.javaVersions().actualVersion(), (Provider<Integer>)indra.javaVersions().target(), (Provider<Integer>)docsRuntimeVersion, (Provider<Integer>)docsTargetVersion);
            multireleaseExtension.alternateVersions().whenObjectAdded(version -> {
                String derivedSetName = MultireleaseSourceSetImpl.versionName(parent, version);
                alternateNames.add(derivedSetName);
            });
            this.registerValidateModule(project, indra, (SourceSet)parent, multireleaseExtension);
        });
        project.afterEvaluate(p -> {
            IndraExtension indra = Indra.extension(p.getExtensions());
            sourceSets.matching(set -> !alternateNames.contains(set.getName())).all(base -> {
                MultireleaseSourceSetImpl extension = (MultireleaseSourceSetImpl)MultireleaseSourceSet.from(base);
                this.usePackagedDependenciesWhenModularJavadocRequired(p.getConfigurations(), (SourceSet)base, extension);
                this.registerCheckExports((Project)p, (SourceSet)base, extension);
                int[] versions = extension.alternateVersions().stream().mapToInt(Integer::intValue).toArray();
                Arrays.sort(versions);
                int baseVersion = (Integer)indra.javaVersions().target().get();
                for (int version : versions) {
                    if (version <= baseVersion) {
                        throw new GradleException("Found declared multirelease variant (version " + version + ") of source set '" + base.getName() + "' which was lower than the base version (" + baseVersion + ")");
                    }
                    if (version > 8) continue;
                    throw new GradleException("Multirelease jars can only be used for variants targeting a Java version greater than 8, but " + version + " was provided in source set " + base.getName());
                }
                NamedDomainObjectProvider baseApiElements = project.getConfigurations().getNames().contains(base.getApiElementsConfigurationName()) ? project.getConfigurations().named(base.getApiElementsConfigurationName()) : null;
                NamedDomainObjectProvider baseRuntimeElements = project.getConfigurations().getNames().contains(base.getRuntimeElementsConfigurationName()) ? project.getConfigurations().named(base.getRuntimeElementsConfigurationName()) : null;
                int length = versions.length;
                for (int idx = 0; idx < length; ++idx) {
                    int version = versions[idx];
                    SourceSet parent = idx == 0 ? base : (SourceSet)sourceSets.getByName(MultireleaseSourceSetImpl.versionName(base, versions[idx - 1]));
                    SourceSet variant = (SourceSet)sourceSets.maybeCreate(MultireleaseSourceSetImpl.versionName(base, version));
                    variant.getJava().setSrcDirs(this.applySourceDirectories(version, base.getJava().getSrcDirs()));
                    variant.getResources().setSrcDirs(this.applySourceDirectories(version, base.getResources().getSrcDirs()));
                    dependencies.add(variant.getImplementationConfigurationName(), (Object)parent.getOutput());
                    variant.setCompileClasspath(variant.getCompileClasspath().plus(parent.getCompileClasspath()));
                    variant.setRuntimeClasspath(variant.getRuntimeClasspath().plus(parent.getRuntimeClasspath()));
                    MultireleaseModulePatchArgumentProvider modulePatch = new MultireleaseModulePatchArgumentProvider(p.getObjects());
                    modulePatch.getModuleName().set(extension.moduleName());
                    modulePatch.getClassDirectories().from(new Object[]{base.getOutput()});
                    for (int i = 0; i < idx; ++i) {
                        modulePatch.getClassDirectories().from(new Object[]{sourceSets.named(MultireleaseSourceSetImpl.versionName(base, versions[i])).map(SourceSet::getOutput)});
                    }
                    this.configureLanguages(project, variant, (Provider<Integer>)indra.javaVersions().actualVersion().map(standard -> Math.max(standard, version)), (Provider<Integer>)project.provider(() -> version));
                    TaskProvider compileJava = tasks.named(variant.getCompileJavaTaskName(), JavaCompile.class, task -> task.getOptions().getCompilerArgumentProviders().add(modulePatch));
                    this.addMultireleaseVariantToJars(tasks, (SourceSet)base, variant, version);
                    this.addMultireleaseVariantToBaseOutgoingVariants(tasks, (TaskProvider<JavaCompile>)compileJava, variant, (NamedDomainObjectProvider<Configuration>)baseApiElements, (NamedDomainObjectProvider<Configuration>)baseRuntimeElements);
                    if (extension.alternateConfigurationActions.isEmpty()) continue;
                    MultireleaseVariantDetails details = MultireleaseVariantDetails.details(base, version, variant);
                    for (Action<MultireleaseVariantDetails> action : extension.alternateConfigurationActions) {
                        action.execute((Object)details);
                    }
                }
                if (versions.length > 0) {
                    this.configureMultireleaseJarManifestAttribute(tasks, (SourceSet)base);
                }
            });
        });
    }

    private void usePackagedDependenciesWhenModularJavadocRequired(ConfigurationContainer configurations, SourceSet base, MultireleaseSourceSetImpl extension) {
        configurations.named(base.getCompileClasspathConfigurationName(), config -> {
            if (((Boolean)extension.applyToJavadoc().get()).booleanValue()) {
                config.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.objects.named(LibraryElements.class, "jar")));
            }
        });
    }

    private void registerCheckExports(Project project, SourceSet base, MultireleaseSourceSetImpl extension) {
        if (extension.exportValidation.isEmpty()) {
            return;
        }
        TaskContainer tasks = project.getTasks();
        TaskProvider checkModuleExports = tasks.register(base.getTaskName("check", "ModuleExports"), CheckModuleExports.class, task -> {
            if (!tasks.getNames().contains(base.getJarTaskName())) {
                task.setEnabled(false);
                return;
            }
            task.setGroup("verification");
            task.getCheckedModule().set(tasks.named(base.getJarTaskName(), org.gradle.jvm.tasks.Jar.class).flatMap(j -> j.getArchiveFile()));
            for (Action<? super CheckModuleExports> action : extension.exportValidation) {
                action.execute((Object)task);
            }
        });
        tasks.named("check", check -> check.dependsOn(new Object[]{checkModuleExports}));
    }

    private void addMultireleaseVariantToJars(TaskContainer tasks, SourceSet base, SourceSet variant, int version) {
        SourceSetOutput output = variant.getOutput();
        String jarTaskName = base.getJarTaskName();
        tasks.matching(task -> task.getName().equals(jarTaskName)).configureEach(task -> {
            Jar jarTask = (Jar)task;
            jarTask.into((Object)(MULTI_RELEASE_PATH + version), spec -> spec.from(new Object[]{output}));
        });
        SourceDirectorySet allSource = variant.getAllSource();
        String sourcesJarTaskName = base.getSourcesJarTaskName();
        tasks.matching(task -> task.getName().equals(sourcesJarTaskName)).configureEach(task -> {
            Jar jarTask = (Jar)task;
            jarTask.into((Object)(MULTI_RELEASE_PATH + version), spec -> spec.from(new Object[]{allSource}));
        });
    }

    private void addMultireleaseVariantToBaseOutgoingVariants(TaskContainer tasks, TaskProvider<JavaCompile> compileJava, SourceSet variant, NamedDomainObjectProvider<Configuration> baseApiElements, NamedDomainObjectProvider<Configuration> baseRuntimeElements) {
        if (baseApiElements != null) {
            baseApiElements.configure(conf -> conf.getOutgoing().getVariants().named(CLASSES_VARIANT, classesVariant -> classesVariant.artifact((Object)compileJava.flatMap(AbstractCompile::getDestinationDirectory), artifact -> artifact.builtBy(new Object[]{compileJava}))));
        }
        if (baseRuntimeElements != null) {
            TaskProvider processResources = tasks.named(variant.getProcessResourcesTaskName(), ProcessResources.class);
            baseRuntimeElements.configure(conf -> {
                conf.getOutgoing().getVariants().named(CLASSES_VARIANT, classesVariant -> classesVariant.artifact((Object)compileJava.flatMap(AbstractCompile::getDestinationDirectory), artifact -> artifact.builtBy(new Object[]{compileJava})));
                conf.getOutgoing().getVariants().named(RESOURCES_VARAINT, classesVariant -> classesVariant.artifact((Object)processResources.map(Copy::getDestinationDir), artifact -> artifact.builtBy(new Object[]{processResources})));
            });
        }
    }

    private void configureMultireleaseJarManifestAttribute(TaskContainer tasks, SourceSet base) {
        tasks.matching(task -> task.getName().equals(base.getJarTaskName())).configureEach(task -> {
            Jar jarTask = (Jar)task;
            jarTask.getManifest().getAttributes().put((Object)MULTI_RELEASE_ATTRIBUTE, (Object)true);
        });
    }

    private Set<File> applySourceDirectories(int version, Set<File> originalFiles) {
        HashSet<File> sourceDirs = new HashSet<File>(originalFiles.size());
        for (File file : originalFiles) {
            sourceDirs.add(new File(file.getParentFile(), file.getName() + version));
        }
        return sourceDirs;
    }

    private void configureStandardSourceSetMultireleaseActions(Project project, IndraExtension indra, TaskContainer tasks, SourceSetContainer sourceSets) {
        SourceSet mainSet = (SourceSet)sourceSets.getByName("main");
        MultireleaseSourceSet main = MultireleaseSourceSet.from(mainSet);
        project.afterEvaluate(p -> {
            if (!main.alternateVersions().isEmpty()) {
                ProjectLayout layout = p.getLayout();
                TaskProvider jarTask = tasks.named(mainSet.getJarTaskName(), Jar.class);
                SourceSetOutput mainOutput = mainSet.getOutput();
                tasks.withType(Test.class).configureEach(test -> {
                    test.dependsOn(new Object[]{jarTask});
                    test.setClasspath(layout.files(new Object[]{jarTask.flatMap(AbstractArchiveTask::getArchiveFile), test.getClasspath()}).minus((FileCollection)mainOutput));
                });
            }
        });
        Property<Boolean> modularJavadoc = main.applyToJavadoc();
        ConfigurableFileCollection modulePatch = project.getObjects().fileCollection();
        modulePatch.from(new Object[]{mainSet.getAllJava()});
        TaskCollection javadocTasks = tasks.matching(t -> t.getName().equals(mainSet.getJavadocTaskName()) && t instanceof Javadoc);
        main.configureVariants((Action<MultireleaseVariantDetails>)((Action)details -> {
            javadocTasks.configureEach(t -> {
                Javadoc javadocTask = (Javadoc)t;
                if (((Boolean)modularJavadoc.get()).booleanValue()) {
                    javadocTask.source(new Object[]{details.variant().getAllJava()});
                    javadocTask.setClasspath(javadocTask.getClasspath().plus((FileCollection)details.variant().getOutput()));
                }
            });
            modulePatch.from(new Object[]{details.variant().getAllJava().getSourceDirectories()});
        }));
        javadocTasks.configureEach(t -> {
            Property<String> moduleName = main.moduleName();
            t.getInputs().property("moduleName", moduleName).optional(true);
            t.getInputs().property("isMultireleaseModular", (Object)modularJavadoc);
            t.doFirst((Action)new AddModulePatchAction(modularJavadoc, moduleName, (FileCollection)modulePatch));
        });
        MultireleaseSourceSet test = MultireleaseSourceSet.from((SourceSet)sourceSets.getByName("test"));
        test.alternateVersions().whenObjectAdded(version -> indra.javaVersions().testWith().add(version));
        test.configureVariants((Action<MultireleaseVariantDetails>)((Action)details -> {
            Provider<Integer> actualVersion = indra.javaVersions().actualVersion();
            FileCollection testClassesDirs = details.variant().getOutput().getClassesDirs();
            FileCollection runtimeClasspath = details.variant().getRuntimeClasspath();
            String variantCompile = details.variant().getCompileJavaTaskName();
            int target = details.targetVersion();
            tasks.named("test", Test.class, testTask -> {
                if ((Integer)actualVersion.get() >= target) {
                    testTask.setTestClassesDirs(testTask.getTestClassesDirs().plus(testClassesDirs));
                    testTask.setClasspath(testTask.getClasspath().plus(runtimeClasspath));
                    testTask.dependsOn(new Object[]{variantCompile});
                }
            });
            tasks.matching(it -> it.getName().equals(Indra.testJava(target))).configureEach(task -> {
                if (!(task instanceof Test)) {
                    return;
                }
                Test testTask = (Test)task;
                testTask.setTestClassesDirs(testTask.getTestClassesDirs().plus(testClassesDirs));
                testTask.setClasspath(testTask.getClasspath().plus(runtimeClasspath));
                testTask.dependsOn(new Object[]{variantCompile});
            });
        }));
    }

    private void configureEclipseProjectVersions(Project project, EclipseModel model, IndraExtension indra, SourceSetContainer sourceSets) {
        project.afterEvaluate(p -> {
            int baseVersion;
            int sourceVersion = baseVersion = ((Integer)indra.javaVersions().target().get()).intValue();
            for (SourceSet set : sourceSets) {
                @Nullable MultireleaseSourceSet mr = (MultireleaseSourceSet)set.getExtensions().findByType(MultireleaseSourceSet.class);
                if (mr == null) continue;
                Iterator iterator = mr.alternateVersions().iterator();
                while (iterator.hasNext()) {
                    int candidate = (Integer)iterator.next();
                    sourceVersion = Math.max(sourceVersion, candidate);
                }
            }
            if (sourceVersion != baseVersion) {
                JavaVersion compatibility = JavaVersion.toVersion((Object)sourceVersion);
                model.getJdt().setSourceCompatibility(compatibility);
                model.getJdt().setTargetCompatibility(compatibility);
            }
        });
    }

    private void configureEclipseModulePath(Project project, EclipseModel eclipse, SourceSetContainer sourceSets) {
        Property inferModulePath = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getModularity().getInferModulePath();
        Property declaresModule = project.getObjects().property(Boolean.class).convention(project.provider(() -> {
            for (SourceSet set : sourceSets) {
                MultireleaseSourceSet mr = (MultireleaseSourceSet)set.getExtensions().findByType(MultireleaseSourceSet.class);
                if (mr == null || !mr.moduleName().isPresent()) continue;
                return true;
            }
            return false;
        }));
        declaresModule.finalizeValueOnRead();
        eclipse.getClasspath().getFile().whenMerged(arg_0 -> IndraMultireleasePlugin.lambda$configureEclipseModulePath$48(declaresModule, (Provider)inferModulePath, arg_0));
    }

    private void registerValidateModule(Project project, IndraExtension indra, SourceSet set, MultireleaseSourceSet multirelease) {
        JavaToolchainService toolchains = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        Provider maxMultirelase = project.provider(multirelease::alternateVersions).map(alternates -> {
            int target = -1;
            Iterator iterator = alternates.iterator();
            while (iterator.hasNext()) {
                int alternate = (Integer)iterator.next();
                target = Math.max(target, alternate);
            }
            return target;
        });
        TaskProvider provider = project.getTasks().register(set.getTaskName("validate", "Module"), JDeps.class, jdeps -> {
            jdeps.setGroup("verification");
            jdeps.onlyIf(t -> multirelease.moduleName().isPresent());
            jdeps.getJavaLauncher().set(toolchains.launcherFor(spec -> spec.getLanguageVersion().set(indra.javaVersions().actualVersion().zip(maxMultirelase, (actual, alternate) -> JavaLanguageVersion.of((int)Math.max(actual, alternate))))));
            jdeps.getMultireleaseVersion().set(maxMultirelase.map(item -> {
                if (item == null || item == -1) {
                    return null;
                }
                return item;
            }));
            jdeps.getModulePath().from(new Object[]{set.getRuntimeClasspath().minus((FileCollection)set.getOutput())});
            jdeps.getModulePath().from(new Object[]{set.getCompileClasspath()});
            TaskContainer tasks = project.getTasks();
            if (tasks.getNames().contains(set.getJarTaskName())) {
                jdeps.getModulePath().from(new Object[]{tasks.named(set.getJarTaskName(), Jar.class).map(DefaultTask::getOutputs)});
            } else {
                jdeps.getModulePath().from(new Object[]{set.getOutput()});
            }
            jdeps.getArguments().addAll((Object[])new String[]{"--check"});
            jdeps.getArguments().add(multirelease.moduleName());
        });
        multirelease.configureVariants((Action<MultireleaseVariantDetails>)((Action)details -> provider.configure(jdeps -> {
            jdeps.getModulePath().from(new Object[]{details.variant().getCompileClasspath().minus((FileCollection)details.base().getOutput()).minus((FileCollection)details.variant().getOutput())});
            jdeps.getModulePath().from(new Object[]{details.variant().getRuntimeClasspath().minus((FileCollection)details.base().getOutput()).minus((FileCollection)details.variant().getOutput())});
        })));
    }

    private static /* synthetic */ void lambda$configureEclipseModulePath$48(Property declaresModule, Provider inferModulePath, Object model) {
        Classpath cp = (Classpath)model;
        if (!((Boolean)declaresModule.get()).booleanValue()) {
            return;
        }
        for (ClasspathEntry entry : cp.getEntries()) {
            if (entry instanceof Library) {
                Library library = (Library)entry;
                File libraryFile = library.getLibrary().getFile();
                if (!ModularityDetecter.isModule(libraryFile, (Boolean)inferModulePath.get())) continue;
                library.getEntryAttributes().put(ECLIPSE_MODULE_ATTRIBUTE, "true");
                continue;
            }
            if (!(entry instanceof ProjectDependency)) continue;
            ((ProjectDependency)entry).getEntryAttributes().put(ECLIPSE_MODULE_ATTRIBUTE, "true");
        }
    }

    static final class AddModulePatchAction
    implements Action<Task> {
        private final Property<Boolean> modularJavadoc;
        private final Property<String> moduleName;
        private final FileCollection modulePatchPath;

        AddModulePatchAction(Property<Boolean> modularJavadoc, Property<String> moduleName, FileCollection modulePatchPath) {
            this.modularJavadoc = modularJavadoc;
            this.moduleName = moduleName;
            this.modulePatchPath = modulePatchPath;
        }

        public void execute(@NotNull Task task) {
            Javadoc javadocTask = (Javadoc)task;
            if (((Boolean)this.modularJavadoc.get()).booleanValue() && this.moduleName.isPresent()) {
                ((StandardJavadocDocletOptions)javadocTask.getOptions()).addStringOption("-patch-module", (String)this.moduleName.get() + "=" + this.modulePatchPath.getAsPath());
            }
        }
    }
}

