/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.internal.multirelease;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.kyori.mammoth.Properties;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.Nullable;

class MultireleaseModulePatchArgumentProvider
implements CommandLineArgumentProvider {
    private final Property<String> moduleName;
    private final ConfigurableFileCollection classDirectories;

    MultireleaseModulePatchArgumentProvider(ObjectFactory objects) {
        this.moduleName = objects.property(String.class);
        this.classDirectories = objects.fileCollection();
    }

    @Input
    @Optional
    public Property<String> getModuleName() {
        return this.moduleName;
    }

    @Internal
    public ConfigurableFileCollection getClassDirectories() {
        return this.classDirectories;
    }

    public Iterable<String> asArguments() {
        @Nullable String moduleName = (String)this.moduleName.getOrNull();
        if (moduleName == null) {
            return Collections.emptyList();
        }
        String directories = ((ConfigurableFileCollection)Properties.finalized((HasConfigurableValue)this.getClassDirectories())).getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator, moduleName + "=", ""));
        return Arrays.asList("--patch-module", directories);
    }
}

