/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import javax.inject.Inject;
import net.kyori.indra.crossdoc.CrossdocExtension;
import net.kyori.indra.crossdoc.NameBasedProjectDocumentationUrlProvider;
import net.kyori.indra.crossdoc.NameBasedProjectDocumentationUrlProviderImpl;
import net.kyori.indra.crossdoc.ProjectDocumentationUrlProvider;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

class CrossdocExtensionImpl
implements CrossdocExtension {
    private final ObjectFactory objects;
    private final Property<String> baseUrlProperty;
    private final Property<ProjectDocumentationUrlProvider> docUrlProviderProperty;
    private final Provider<String> projectVersionProvider;

    @Inject
    public CrossdocExtensionImpl(ObjectFactory objects, ProviderFactory providers, Project project) {
        this.objects = objects;
        this.baseUrlProperty = objects.property(String.class);
        this.docUrlProviderProperty = objects.property(ProjectDocumentationUrlProvider.class);
        this.projectVersionProvider = providers.provider(() -> String.valueOf(project.getVersion()));
        NameBasedProjectDocumentationUrlProvider defaultProvider = (NameBasedProjectDocumentationUrlProvider)this.objects.newInstance(NameBasedProjectDocumentationUrlProviderImpl.class, new Object[0]);
        defaultProvider.getVersion().convention(this.projectVersionProvider);
        this.docUrlProviderProperty.convention((Object)defaultProvider);
    }

    @Override
    public Property<ProjectDocumentationUrlProvider> projectDocumentationUrlProvider() {
        return this.docUrlProviderProperty;
    }

    @Override
    public Property<String> baseUrl() {
        return this.baseUrlProperty;
    }

    @Override
    public void nameBasedDocumentationUrlProvider(Action<? super NameBasedProjectDocumentationUrlProvider> action) {
        NameBasedProjectDocumentationUrlProvider provider = (NameBasedProjectDocumentationUrlProvider)this.objects.newInstance(NameBasedProjectDocumentationUrlProviderImpl.class, new Object[0]);
        provider.getVersion().convention(this.projectVersionProvider);
        action.execute((Object)provider);
        this.docUrlProviderProperty.set((Object)provider);
    }
}

