/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

interface BuildTreeComparer {
    public static final boolean HAS_GRADLE_8_3 = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.3")) >= 0;

    @NotNull
    public static BuildTreeComparer comparer(@NotNull Project project) {
        if (HAS_GRADLE_8_3) {
            return new Gradle83Comparer(Objects.requireNonNull(project, "project"));
        }
        return Gradle82OrOlderComparer.INSTANCE;
    }

    public boolean isCurrentBuild(ProjectComponentIdentifier var1);

    public static final class Gradle82OrOlderComparer
    implements BuildTreeComparer {
        static final Gradle82OrOlderComparer INSTANCE = new Gradle82OrOlderComparer();

        private Gradle82OrOlderComparer() {
        }

        @Override
        public boolean isCurrentBuild(ProjectComponentIdentifier identifier) {
            return identifier.getBuild().isCurrentBuild();
        }
    }

    public static final class Gradle83Comparer
    implements BuildTreeComparer {
        private final String projectBuildPath;

        Gradle83Comparer(Project project) {
            String projectPath = project.getPath();
            String absoluteProjectPath = project.getBuildTreePath();
            String buildPath = absoluteProjectPath.substring(0, absoluteProjectPath.length() - projectPath.length());
            this.projectBuildPath = buildPath.isEmpty() ? ":" : buildPath;
        }

        @Override
        public boolean isCurrentBuild(ProjectComponentIdentifier identifier) {
            return this.projectBuildPath.equals(identifier.getBuild().getBuildPath());
        }
    }
}

