/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import java.io.File;
import javax.inject.Inject;
import net.kyori.indra.crossdoc.ProjectDocumentationUrlProvider;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class CopyJavadoc
extends DefaultTask {
    @InputFiles
    public abstract ConfigurableFileCollection getJavadocFiles();

    @Internal
    @Option(option="output", description="The root of the destination for Javadoc publishing")
    public abstract Property<String> getOutputPath();

    @Nested
    public abstract Property<ProjectDocumentationUrlProvider> getDocumentationUrlProvider();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Internal
    protected abstract DirectoryProperty getRootDir();

    @Input
    protected abstract Property<String> getProjectName();

    @Input
    protected abstract Property<String> getProjectPath();

    @Inject
    protected abstract FileSystemOperations getFileSystemOps();

    public CopyJavadoc() {
        Provider relativeUrl = this.getProjectName().zip(this.getProjectPath(), (name, path) -> new Pair<String, String>((String)name, (String)path)).zip(this.getDocumentationUrlProvider(), (namePath, provider) -> provider.createUrl((String)namePath.left, (String)namePath.right));
        this.getOutputDirectory().set(this.getRootDir().dir(this.getOutputPath()).zip(relativeUrl, (base, path) -> base.dir(path)));
    }

    @TaskAction
    public void doTransfer() {
        File dest = ((Directory)this.getOutputDirectory().get()).getAsFile();
        this.getFileSystemOps().delete(spec -> spec.delete(new Object[]{dest}));
        dest.mkdirs();
        this.getFileSystemOps().copy(spec -> {
            spec.from(new Object[]{this.getJavadocFiles()});
            spec.into((Object)dest);
        });
    }

    static final class Pair<A, B> {
        final A left;
        final B right;

        Pair(A left, B right) {
            this.left = left;
            this.right = right;
        }
    }
}

