/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.crossdoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import net.kyori.indra.crossdoc.ProjectDocumentationUrlProvider;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateOfflineLinks
extends DefaultTask {
    private static final String LINK_OFFLINE_OPTION = "-linkoffline";

    @Input
    public abstract Property<String> getLinkBaseUrl();

    @Nested
    public abstract Property<ProjectDocumentationUrlProvider> getUrlProvider();

    @InputFiles
    protected abstract ConfigurableFileCollection getLinkableArtifactFiles();

    @Internal
    public abstract SetProperty<ResolvedArtifactResult> getLinkableArtifacts();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public void generateArgumentFile() throws IOException {
        File outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        outputFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            for (ResolvedArtifactResult it : (Set)this.getLinkableArtifacts().get()) {
                File file = it.getFile();
                ProjectComponentIdentifier identifier = (ProjectComponentIdentifier)it.getId().getComponentIdentifier();
                String projectName = identifier.getProjectName();
                if (!file.isDirectory()) {
                    this.getLogger().info("Failed to link to Javadoc in {} (for {}) because it was not a directory", (Object)file, (Object)projectName);
                    continue;
                }
                Object linkRoot = (String)this.getLinkBaseUrl().get();
                if (!((String)linkRoot).endsWith("/")) {
                    linkRoot = (String)linkRoot + "/";
                }
                writer.append(LINK_OFFLINE_OPTION).append(' ').append((CharSequence)linkRoot).append(((ProjectDocumentationUrlProvider)this.getUrlProvider().get()).createUrl(projectName, identifier.getProjectPath())).append(' ').append(file.getAbsolutePath());
                writer.newLine();
            }
        }
    }
}

