/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.gradle.api.java.archives.Manifest;

public interface IndraGitExtension {
    public static final String MANIFEST_ATTRIBUTE_GIT_COMMIT = "Git-Commit";
    public static final String MANIFEST_ATTRIBUTE_GIT_BRANCH = "Git-Branch";

    default public boolean isPresent() {
        return this.git() != null;
    }

    public @Nullable Git git();

    public @NonNull List<Ref> tags();

    public @Nullable Ref headTag();

    public @Nullable String describe();

    public @Nullable String branchName();

    public @Nullable Ref branch();

    public @Nullable ObjectId commit();

    default public void applyVcsInformationToManifest(Manifest manifest) {
        if (this.isPresent()) {
            @Nullable ObjectId commit = this.commit();
            @Nullable String branchName = this.branchName();
            if (commit != null) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_COMMIT, (Object)commit.name());
            }
            if (branchName != null) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_BRANCH, (Object)branchName);
            }
        }
    }
}

