/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.internal.IndraGitService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;

public class IndraGitExtensionImpl
implements IndraGitExtension {
    private final Logger logger;
    private final Provider<Git> service;

    @Inject
    public IndraGitExtensionImpl(Project project, Provider<IndraGitService> service) {
        this.logger = project.getLogger();
        this.service = service.map(s -> s.git(project));
    }

    @Override
    public @Nullable Git git() {
        return (Git)this.service.getOrNull();
    }

    @Override
    public @NonNull List<Ref> tags() {
        @Nullable Git git = this.git();
        if (git == null) {
            return Collections.emptyList();
        }
        try {
            return git.tagList().call();
        }
        catch (GitAPIException ex) {
            this.logger.error("Failed to query git for a list of tags:", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public @Nullable Ref headTag() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref head = git.getRepository().findRef("HEAD");
            if (head == null) {
                return null;
            }
            ObjectId headCommit = head.getLeaf().getObjectId();
            for (Ref tag : git.tagList().call()) {
                @Nullable ObjectId tagId = tag.getPeeledObjectId();
                if (tagId == null) {
                    tagId = tag.getObjectId();
                }
                if (!ObjectId.isEqual((AnyObjectId)tagId, (AnyObjectId)headCommit)) continue;
                return tag;
            }
        }
        catch (IOException | GitAPIException ex) {
            this.logger.error("Failed to resolve current HEAD tag:", ex);
        }
        return null;
    }

    @Override
    public @Nullable String describe() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            return git.describe().setTags(true).setLong(true).call();
        }
        catch (RefNotFoundException ex) {
            return null;
        }
        catch (GitAPIException ex) {
            this.logger.error("Failed to query git for a 'describe' result:", (Throwable)ex);
            return null;
        }
    }

    @Override
    public @Nullable String branchName() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        @Nullable Ref branch = this.branch();
        return branch == null ? null : Repository.shortenRefName((String)branch.getName());
    }

    @Override
    public @Nullable Ref branch() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref ref = git.getRepository().exactRef("HEAD");
            if (ref == null || !ref.isSymbolic()) {
                return null;
            }
            return ref.getTarget();
        }
        catch (IOException ex) {
            this.logger.error("Failed to query current branch name from git:", (Throwable)ex);
            return null;
        }
    }

    @Override
    public @Nullable ObjectId commit() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref head = git.getRepository().exactRef("HEAD");
            if (head == null) {
                return null;
            }
            return head.getObjectId();
        }
        catch (IOException ex) {
            this.logger.error("Failed to query git for the current HEAD commit:", (Throwable)ex);
            return null;
        }
    }
}

