/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.task;

import net.kyori.indra.git.internal.IndraGitService;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public abstract class RequireClean
extends DefaultTask {
    public RequireClean() {
        this.setGroup("verification");
    }

    @Internal
    public abstract Property<IndraGitService> getGit();

    @TaskAction
    public void check() {
        @Nullable Git git = ((IndraGitService)this.getGit().get()).git(this.getProject());
        if (git == null) {
            return;
        }
        try {
            Status status = git.status().call();
            if (!status.isClean()) {
                StringBuilder message = new StringBuilder("Source root must be clean! Make sure your changes are committed. Changed files:");
                for (String changed : status.getUncommittedChanges()) {
                    message.append(System.lineSeparator()).append("- ").append(changed);
                }
                for (String untracked : status.getUntracked()) {
                    message.append(System.lineSeparator()).append("- ").append(untracked);
                }
                throw new GradleException(message.toString());
            }
        }
        catch (GitAPIException ex) {
            this.getLogger().error("Failed to query clean status of current project repository", (Throwable)ex);
        }
    }
}

