/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.Nullable;

public abstract class IndraGitService
implements BuildService<Parameters>,
AutoCloseable {
    private volatile boolean open = true;
    private final Map<File, GitWrapper> projectRepos = new ConcurrentHashMap<File, GitWrapper>();

    @Nullable
    public Git git(Project project) {
        if (!this.open) {
            throw new IllegalStateException("Tried to access git repository after close");
        }
        @Nullable GitWrapper wrapper = this.projectRepos.get(project.getProjectDir());
        if (wrapper != null) {
            return wrapper.git;
        }
        File rawProjectDir = project.getProjectDir();
        try {
            File rootProjectDir = ((Directory)((Parameters)this.getParameters()).getBaseDirectory().get()).getAsFile().getCanonicalFile();
            File realProjectDir = rawProjectDir.getCanonicalFile();
            if (!realProjectDir.getPath().startsWith(rootProjectDir.getPath())) {
                throw new IllegalArgumentException("Project directory " + rawProjectDir + " was no within the root project!");
            }
            File targetDir = realProjectDir;
            do {
                if (!IndraGitService.isGitDir(targetDir)) continue;
                GitWrapper potentialExisting = this.projectRepos.get(targetDir);
                if (potentialExisting != null) {
                    this.projectRepos.put(rawProjectDir, potentialExisting);
                    return potentialExisting.git;
                }
                try {
                    Git repo = Git.open((File)targetDir);
                    GitWrapper repoWrapper = new GitWrapper(repo);
                    GitWrapper existing = this.projectRepos.putIfAbsent(targetDir, repoWrapper);
                    if (existing != null) {
                        repo.close();
                        repoWrapper = existing;
                    }
                    this.projectRepos.put(rawProjectDir, repoWrapper);
                    return repoWrapper.git;
                }
                catch (RepositoryNotFoundException repositoryNotFoundException) {
                    // empty catch block
                }
            } while (!rootProjectDir.equals(targetDir) && (targetDir = targetDir.getParentFile()) != null);
            this.projectRepos.put(rawProjectDir, GitWrapper.NOT_FOUND);
        }
        catch (IOException ex) {
            project.getLogger().warn("Failed to open git repository for {}:", (Object)project.getDisplayName(), (Object)ex);
        }
        return null;
    }

    private static boolean isGitDir(File file) {
        return new File(file, ".git").exists();
    }

    @Override
    public void close() {
        this.open = false;
        HashSet<GitWrapper> repos = new HashSet<GitWrapper>(this.projectRepos.values());
        this.projectRepos.clear();
        for (GitWrapper wrapper : repos) {
            if (wrapper.git == null) continue;
            wrapper.git.close();
        }
    }

    private static class GitWrapper {
        static final GitWrapper NOT_FOUND = new GitWrapper(null);
        @Nullable
        final Git git;

        GitWrapper(@Nullable Git repo) {
            this.git = repo;
        }
    }

    public static interface Parameters
    extends BuildServiceParameters {
        public DirectoryProperty getBaseDirectory();
    }
}

