/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.io.File;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.internal.IndraGitExtensionImpl;
import net.kyori.indra.git.internal.IndraGitService;
import net.kyori.indra.git.task.RequireClean;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public class GitPlugin
implements Plugin<Object> {
    private static final String EXTENSION_NAME = "indraGit";
    private static final String SERVICE_NAME = "indraGitService";
    public static final String REQUIRE_CLEAN_TASK = "requireClean";

    public void apply(@NotNull Object projectOrSettings) {
        if (projectOrSettings instanceof Project) {
            this.applyToProject((Project)projectOrSettings);
        } else if (projectOrSettings instanceof Settings) {
            this.applyToSettings((Settings)projectOrSettings);
        } else {
            throw new InvalidUserDataException("The net.kyori.indra.git plugin can only be applied to a Project or Settings!");
        }
    }

    private void applyToProject(@NotNull Project project) {
        Provider<IndraGitService> service = this.applyCommon(project.getGradle(), project.getExtensions(), project.getRootDir(), project.getProjectDir(), project.getDisplayName());
        project.getTasks().register(REQUIRE_CLEAN_TASK, RequireClean.class, task -> task.getGit().set(service));
    }

    private void applyToSettings(@NotNull Settings settings) {
        this.applyCommon(settings.getGradle(), settings.getExtensions(), settings.getRootDir(), settings.getRootDir(), "settings");
    }

    private Provider<IndraGitService> applyCommon(@NotNull Gradle gradle, ExtensionContainer extensions, File rootDir, File projectDir, String displayName) {
        Provider service = gradle.getSharedServices().registerIfAbsent(SERVICE_NAME, IndraGitService.class, params -> ((IndraGitService.Parameters)params.getParameters()).getBaseDirectory().set(rootDir));
        extensions.create(IndraGitExtension.class, EXTENSION_NAME, IndraGitExtensionImpl.class, new Object[]{projectDir, displayName, service});
        return service;
    }
}

