/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.io.File;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.internal.IndraGitExtensionImpl;
import net.kyori.indra.git.internal.IndraGitService;
import net.kyori.indra.git.task.RequireClean;
import net.kyori.mammoth.ProjectOrSettingsPlugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

public class GitPlugin
implements ProjectOrSettingsPlugin {
    private static final String EXTENSION_NAME = "indraGit";
    private static final String SERVICE_NAME = "indraGitService";
    public static final String REQUIRE_CLEAN_TASK = "requireClean";

    public void applyToProject(@NotNull Project target, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        Provider<IndraGitService> service = this.applyCommon(target.getGradle(), extensions, target.getRootDir(), target.getProjectDir(), target.getDisplayName());
        tasks.register(REQUIRE_CLEAN_TASK, RequireClean.class, task -> task.getGit().set(service));
    }

    public void applyToSettings(@NotNull Settings target, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions) {
        this.applyCommon(target.getGradle(), extensions, target.getRootDir(), target.getRootDir(), "settings");
    }

    private Provider<IndraGitService> applyCommon(@NotNull Gradle gradle, ExtensionContainer extensions, File rootDir, File projectDir, String displayName) {
        Provider service = gradle.getSharedServices().registerIfAbsent(SERVICE_NAME, IndraGitService.class, params -> ((IndraGitService.Parameters)params.getParameters()).getBaseDirectory().set(rootDir));
        extensions.create(IndraGitExtension.class, EXTENSION_NAME, IndraGitExtensionImpl.class, new Object[]{projectDir, displayName, service});
        return service;
    }
}

