/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.internal.IndraGitService;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraGitExtensionImpl
implements IndraGitExtension {
    private static final Logger LOGGER = Logging.getLogger(IndraGitExtensionImpl.class);
    private final Provider<Git> service;

    @Inject
    public IndraGitExtensionImpl(File projectDir, String displayName, Provider<IndraGitService> service) {
        this.service = service.map(s -> s.git(projectDir, displayName));
    }

    @Override
    @Nullable
    public Git git() {
        return (Git)this.service.getOrNull();
    }

    @Override
    @NotNull
    public List<Ref> tags() {
        @Nullable Git git = this.git();
        if (git == null) {
            return Collections.emptyList();
        }
        try {
            return git.tagList().call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Failed to query git for a list of tags:", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Ref headTag() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref head = git.getRepository().findRef("HEAD");
            if (head == null) {
                return null;
            }
            ObjectId headCommit = head.getLeaf().getObjectId();
            try (RevWalk walk = new RevWalk(git.getRepository());){
                Ref tag;
                RevObject parsed;
                ObjectId commitId;
                Iterator iterator = git.tagList().call().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!ObjectId.isEqual((AnyObjectId)(commitId = (parsed = walk.peel(walk.parseAny((AnyObjectId)(tag = (Ref)iterator.next()).getObjectId()))).toObjectId()), (AnyObjectId)headCommit));
                Ref ref = tag;
                return ref;
            }
        }
        catch (IOException | GitAPIException ex) {
            LOGGER.error("Failed to resolve current HEAD tag:", ex);
        }
        return null;
    }

    @Override
    @Nullable
    public String describe() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            return git.describe().setTags(true).setLong(true).call();
        }
        catch (RefNotFoundException ex) {
            return null;
        }
        catch (GitAPIException ex) {
            LOGGER.error("Failed to query git for a 'describe' result:", (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public String branchName() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        @Nullable Ref branch = this.branch();
        return branch == null ? null : Repository.shortenRefName((String)branch.getName());
    }

    @Override
    @Nullable
    public Ref branch() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref ref = git.getRepository().exactRef("HEAD");
            if (ref == null || !ref.isSymbolic()) {
                return null;
            }
            return ref.getTarget();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to query current branch name from git:", (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public ObjectId commit() {
        @Nullable Git git = this.git();
        if (git == null) {
            return null;
        }
        try {
            @Nullable Ref head = git.getRepository().exactRef("HEAD");
            if (head == null) {
                return null;
            }
            return head.getObjectId();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to query git for the current HEAD commit:", (Throwable)ex);
            return null;
        }
    }
}

