/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.io.File;
import javax.inject.Inject;
import net.kyori.indra.git.IndraGitExtension;
import net.kyori.indra.git.internal.GitCache;
import net.kyori.indra.git.internal.IndraGitExtensionImpl;
import net.kyori.indra.git.internal.IndraGitService;
import net.kyori.indra.git.task.RepositoryTask;
import net.kyori.indra.git.task.RequireClean;
import net.kyori.indra.git.task.RequireTagged;
import net.kyori.mammoth.ProjectOrSettingsPlugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class GitPlugin
implements ProjectOrSettingsPlugin {
    private static final String EXTENSION_NAME = "indraGit";
    public static final String REQUIRE_CLEAN_TASK = "requireClean";
    public static final String REQUIRE_TAGGED_TASK = "requireTagged";

    @Inject
    protected abstract BuildEventsListenerRegistry getListenerRegistry();

    public void applyToProject(@NotNull Project target, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        Provider<IndraGitService> service = this.applyCommon(target.getGradle(), extensions, target.getRootDir(), target.getProjectDir(), target.getDisplayName());
        tasks.register(REQUIRE_CLEAN_TASK, RequireClean.class);
        tasks.register(REQUIRE_TAGGED_TASK, RequireTagged.class);
        tasks.withType(RepositoryTask.class).configureEach(task -> {
            task.getGit().set(service);
            task.usesService(service);
        });
    }

    public void applyToSettings(@NotNull Settings target, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions) {
        this.applyCommon(target.getGradle(), extensions, target.getRootDir(), target.getRootDir(), "settings");
    }

    private Provider<IndraGitService> applyCommon(@NotNull Gradle gradle, ExtensionContainer extensions, File rootDir, File projectDir, String displayName) {
        Provider service = gradle.getSharedServices().registerIfAbsent("indraGitService", IndraGitService.class, params -> ((IndraGitService.Parameters)params.getParameters()).getBaseDirectory().set(rootDir));
        this.getListenerRegistry().onTaskCompletion(service);
        GitCache.getOrCreate(rootDir);
        extensions.create(IndraGitExtension.class, EXTENSION_NAME, IndraGitExtensionImpl.class, new Object[]{rootDir, projectDir, displayName});
        return service;
    }
}

