/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCache {
    private static final ConcurrentMap<File, Instance> PROJECT_CACHES = new ConcurrentHashMap<File, Instance>();

    public static GitProvider getOrCreate(File rootDir) {
        return PROJECT_CACHES.computeIfAbsent(rootDir, Instance::new);
    }

    public static GitProvider get(File rootDir) {
        GitProvider ret = (GitProvider)PROJECT_CACHES.get(rootDir);
        if (ret == null) {
            throw new IllegalArgumentException("No git provider is present for root directory " + rootDir);
        }
        return ret;
    }

    public static void close(GitProvider provider) {
        Instance inst = (Instance)provider;
        if (PROJECT_CACHES.remove(inst.baseDirectory) != inst) {
            throw new IllegalStateException("The provided instance has already been closed!");
        }
        inst.close();
    }

    private GitCache() {
    }

    @ApiStatus.NonExtendable
    public static interface GitProvider {
        @Nullable
        public Git git(File var1, @NotNull String var2);
    }

    private static final class Instance
    implements Closeable,
    GitProvider {
        private static final Logger LOGGER = Logging.getLogger(GitCache.class);
        private final File baseDirectory;
        private volatile boolean open = true;
        private final Map<File, GitWrapper> projectRepos = new ConcurrentHashMap<File, GitWrapper>();
        private static final String GIT_DIR = ".git";
        private static final String GITDIR_PREFIX = "gitdir:";

        Instance(File baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        @Override
        @Nullable
        public Git git(File projectDir, @NotNull String displayName) {
            if (!this.open) {
                throw new IllegalStateException("Tried to access git repository after close");
            }
            @Nullable GitWrapper wrapper = this.projectRepos.get(projectDir);
            if (wrapper != null) {
                return wrapper.git;
            }
            File rawProjectDir = projectDir;
            try {
                File rootProjectDir = this.baseDirectory.getCanonicalFile();
                File realProjectDir = rawProjectDir.getCanonicalFile();
                if (!realProjectDir.getPath().startsWith(rootProjectDir.getPath())) {
                    throw new IllegalArgumentException("Project directory " + rawProjectDir + " was not within the root project!");
                }
                File targetDir = realProjectDir;
                do {
                    if (Instance.isGitDir(targetDir)) {
                        LOGGER.debug("indra-git: Examining directory {} for {}", (Object)targetDir, (Object)displayName);
                        GitWrapper potentialExisting = this.projectRepos.get(targetDir);
                        if (potentialExisting != null) {
                            LOGGER.info("indra-git: Found existing git repository for {} starting in directory {} via {}", new Object[]{displayName, rawProjectDir, targetDir});
                            this.projectRepos.put(rawProjectDir, potentialExisting);
                            return potentialExisting.git;
                        }
                        try {
                            @Nullable File realGit = Instance.resolveGit(targetDir);
                            if (realGit != null) {
                                Repository repo = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setWorkTree(targetDir)).setGitDir(realGit)).setMustExist(true)).build();
                                GitWrapper repoWrapper = new GitWrapper(repo);
                                GitWrapper existing = this.projectRepos.putIfAbsent(targetDir, repoWrapper);
                                if (existing != null) {
                                    repo.close();
                                    repoWrapper = existing;
                                } else {
                                    LOGGER.info("indra-git: Located and initialized repository for project {} in {}, with git directory at {}", new Object[]{displayName, targetDir, repo.getDirectory()});
                                }
                                this.projectRepos.put(rawProjectDir, repoWrapper);
                                return repoWrapper.git;
                            }
                        }
                        catch (RepositoryNotFoundException ex) {
                            LOGGER.debug("indra-git: Unable to open repository found in {} for {}", new Object[]{targetDir, displayName, ex});
                        }
                        continue;
                    }
                    LOGGER.debug("indra-git: Skipping directory {} while locating repository for {}", (Object)targetDir, (Object)displayName);
                } while (!rootProjectDir.equals(targetDir) && (targetDir = targetDir.getParentFile()) != null);
                this.projectRepos.put(rawProjectDir, GitWrapper.NOT_FOUND);
            }
            catch (IOException ex) {
                LOGGER.warn("indra-git: Failed to open git repository for {}:", (Object)displayName, (Object)ex);
            }
            LOGGER.info("indra-git: No git repository found for {}", (Object)displayName);
            return null;
        }

        private static boolean isGitDir(File file) {
            return new File(file, GIT_DIR).exists();
        }

        private static File resolveGit(File projectDir) throws IOException {
            if (!projectDir.getName().equals(GIT_DIR)) {
                return Instance.resolveGit(new File(projectDir, GIT_DIR));
            }
            if ((projectDir = projectDir.getCanonicalFile()).isDirectory()) {
                return projectDir;
            }
            if (projectDir.isFile()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(projectDir), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith(GITDIR_PREFIX)) continue;
                        File file = new File(projectDir.getParentFile(), line.substring(GITDIR_PREFIX.length()).trim());
                        return file;
                    }
                }
            }
            LOGGER.warn("indra-git: Unable to determine actual git directory from {}", (Object)projectDir);
            return null;
        }

        @Override
        public void close() {
            this.open = false;
            HashSet<GitWrapper> repos = new HashSet<GitWrapper>(this.projectRepos.values());
            this.projectRepos.clear();
            for (GitWrapper wrapper : repos) {
                if (wrapper.repository == null) continue;
                wrapper.repository.close();
            }
        }
    }

    private static class GitWrapper {
        static final GitWrapper NOT_FOUND = new GitWrapper(null);
        @Nullable
        final Git git;
        @Nullable
        final Repository repository;

        GitWrapper(@Nullable Repository repo) {
            this.repository = repo;
            this.git = repo == null ? null : Git.wrap((Repository)repo);
        }
    }
}

