/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.gradle;

import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PublishPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.kyori.indra.Indra;
import net.kyori.indra.IndraExtension;
import net.kyori.indra.IndraPlugin;
import net.kyori.indra.api.model.SourceCodeManagement;
import net.kyori.indra.gradle.IndraPluginPublishingExtension;
import net.kyori.indra.gradle.IndraPluginPublishingExtensionImpl;
import net.kyori.indra.internal.AbstractIndraPublishingPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;

public class GradlePluginPublishingPlugin
extends AbstractIndraPublishingPlugin {
    private static final String EXTENSION_NAME = "indraPluginPublishing";

    protected void extraApplySteps(Project project) {
        project.getPlugins().withType(PublishPlugin.class, $ -> {
            PluginBundleExtension pluginBundleExtension = (PluginBundleExtension)project.getExtensions().getByType(PluginBundleExtension.class);
            BiConsumer<String, String> copyProperty = (definedProperty, originalProperty) -> {
                Object property = project.findProperty(definedProperty);
                if (property != null) {
                    project.getExtensions().getExtraProperties().set(originalProperty, property);
                }
            };
            copyProperty.accept("pluginPortalApiKey", "gradle.publish.key");
            copyProperty.accept("pluginPortalApiSecret", "gradle.publish.secret");
            project.getPlugins().withType(JavaGradlePluginPlugin.class, $$ -> {
                IndraPluginPublishingExtension extension = (IndraPluginPublishingExtension)project.getExtensions().create(IndraPluginPublishingExtension.class, EXTENSION_NAME, IndraPluginPublishingExtensionImpl.class, new Object[]{project.getExtensions().getByType(GradlePluginDevelopmentExtension.class), pluginBundleExtension});
                extension.pluginIdBase().convention(project.provider(() -> (String)project.getGroup()));
                project.afterEvaluate(p -> {
                    List tags;
                    if (extension.bundleTags().isPresent() && !(tags = (List)extension.bundleTags().get()).isEmpty()) {
                        pluginBundleExtension.setTags((Collection)tags);
                    }
                    if (extension.website().isPresent()) {
                        pluginBundleExtension.setWebsite((String)extension.website().get());
                    }
                });
            });
            project.afterEvaluate(p -> {
                IndraExtension indraExtension = Indra.extension((ExtensionContainer)p.getExtensions());
                if (indraExtension.scm().isPresent() && pluginBundleExtension.getVcsUrl() == null) {
                    pluginBundleExtension.setVcsUrl(((SourceCodeManagement)indraExtension.scm().get()).url());
                }
                if (p.getDescription() != null && pluginBundleExtension.getDescription() == null) {
                    pluginBundleExtension.setDescription(p.getDescription());
                }
            });
        });
        project.getPlugins().withType(IndraPlugin.class, $ -> Indra.extension((ExtensionContainer)project.getExtensions()).includeJavaSoftwareComponentInPublications().set((Object)false));
    }

    protected void applyPublishingActions(PublishingExtension extension, Set<Action<MavenPublication>> actions) {
        extension.getPublications().withType(MavenPublication.class).configureEach(publication -> {
            for (Action action : actions) {
                action.execute(publication);
            }
        });
    }

    protected void configurePublications(PublishingExtension extension, Action<MavenPublication> action) {
        extension.getPublications().withType(MavenPublication.class).configureEach(action);
    }
}

