/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.gradle;

import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import java.util.List;
import javax.inject.Inject;
import net.kyori.indra.gradle.IndraPluginPublishingExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraPluginPublishingExtensionImpl
implements IndraPluginPublishingExtension {
    private final GradlePluginDevelopmentExtension publishingExtension;
    private final PluginBundleExtension pluginBundleExtension;
    private final ListProperty<String> bundleTags;
    private final Property<String> pluginIdBase;
    private final Property<String> website;

    @Inject
    public IndraPluginPublishingExtensionImpl(ObjectFactory objects, GradlePluginDevelopmentExtension publishingExtension, PluginBundleExtension pluginBundleExtension) {
        this.publishingExtension = publishingExtension;
        this.pluginBundleExtension = pluginBundleExtension;
        this.bundleTags = objects.listProperty(String.class);
        this.pluginIdBase = objects.property(String.class);
        this.website = objects.property(String.class);
    }

    @Override
    @NotNull
    public ListProperty<String> bundleTags() {
        return this.bundleTags;
    }

    @Override
    @NotNull
    public Property<String> pluginIdBase() {
        return this.pluginIdBase;
    }

    @Override
    @NotNull
    public Property<String> website() {
        return this.website;
    }

    @Override
    public void plugin(@NotNull String id, @NotNull String mainClass, @NotNull String displayName, @Nullable String description, @Nullable List<String> tags) {
        String qualifiedId = (String)this.pluginIdBase.get() + '.' + id;
        this.publishingExtension.getPlugins().create(id, plugin -> {
            plugin.setId(qualifiedId);
            plugin.setImplementationClass(mainClass);
            plugin.setDisplayName(displayName);
            if (description != null) {
                plugin.setDescription(description);
            }
        });
        PluginConfig plugin2 = (PluginConfig)this.pluginBundleExtension.getPlugins().maybeCreate(id);
        plugin2.setId(qualifiedId);
        if (description != null) {
            plugin2.setDescription(description);
        }
        plugin2.setDisplayName(displayName);
        if (tags != null && !tags.isEmpty()) {
            plugin2.setTags(tags);
        }
        if (tags != null && this.pluginBundleExtension.getTags().isEmpty()) {
            this.pluginBundleExtension.setTags(tags);
        }
    }
}

