/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.gradle;

import com.gradle.publish.PluginBundleExtension;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import javax.inject.Inject;
import net.kyori.indra.gradle.GradlePluginPublishingPlugin;
import net.kyori.indra.gradle.IndraPluginPublishingExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndraPluginPublishingExtensionImpl
implements IndraPluginPublishingExtension {
    private final GradlePluginDevelopmentExtension publishingExtension;
    @Nullable
    private final PluginBundleExtension pluginBundleExtension;
    private final ListProperty<String> bundleTags;
    private final Property<String> pluginIdBase;
    private final Property<String> website;
    final Property<String> fallbackDescription;

    @Inject
    public IndraPluginPublishingExtensionImpl(ObjectFactory objects, GradlePluginDevelopmentExtension publishingExtension, @Nullable PluginBundleExtension pluginBundleExtension) {
        this.publishingExtension = publishingExtension;
        this.pluginBundleExtension = pluginBundleExtension;
        this.bundleTags = objects.listProperty(String.class);
        this.pluginIdBase = objects.property(String.class);
        this.website = objects.property(String.class);
        this.fallbackDescription = objects.property(String.class);
    }

    @Override
    @NotNull
    public ListProperty<String> bundleTags() {
        return this.bundleTags;
    }

    @Override
    @NotNull
    public Property<String> pluginIdBase() {
        return this.pluginIdBase;
    }

    @Override
    @NotNull
    public Property<String> website() {
        return this.website;
    }

    @Override
    public void plugin(@NotNull String id, @NotNull String mainClass, @NotNull String displayName, @Nullable String description, @Nullable List<String> tags) {
        String qualifiedId = (String)this.pluginIdBase.get() + '.' + id;
        PluginDeclaration created = (PluginDeclaration)this.publishingExtension.getPlugins().create(id, plugin -> {
            plugin.setId(qualifiedId);
            plugin.setImplementationClass(mainClass);
            plugin.setDisplayName(displayName);
            if (description != null) {
                plugin.setDescription(description);
            } else {
                plugin.setDescription((String)this.fallbackDescription.get());
            }
        });
        if (GradlePluginPublishingPlugin.HAS_GRADLE_7_6) {
            this.applyTagsModern(created, tags);
        } else {
            this.applyTagsLegacy(created, tags);
        }
    }

    private void applyTagsLegacy(PluginDeclaration plugin, List<String> tags) {
        if (this.pluginBundleExtension == null) {
            return;
        }
        if (tags != null && !tags.isEmpty()) {
            HashMap<String, SequencedCollection<String>> bundleTags = new HashMap<String, SequencedCollection<String>>(this.pluginBundleExtension.getPluginTags());
            Collection existing = bundleTags.putIfAbsent(plugin.getId(), tags);
            if (existing != null) {
                LinkedHashSet<String> combinedTags = new LinkedHashSet<String>(existing.size() + tags.size());
                combinedTags.addAll(existing);
                combinedTags.addAll(tags);
                bundleTags.put(plugin.getId(), combinedTags);
            }
            this.pluginBundleExtension.setPluginTags(bundleTags);
        }
        if (tags != null && this.pluginBundleExtension.getTags().isEmpty()) {
            this.pluginBundleExtension.setTags(tags);
        }
    }

    private void applyTagsModern(PluginDeclaration plugin, List<String> tags) {
        if (tags != null && !tags.isEmpty()) {
            plugin.getTags().addAll(tags);
        } else {
            plugin.getTags().set(this.bundleTags());
        }
    }
}

