/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.gradle;

import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PublishPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.kyori.indra.Indra;
import net.kyori.indra.IndraExtension;
import net.kyori.indra.IndraPlugin;
import net.kyori.indra.api.model.SourceCodeManagement;
import net.kyori.indra.gradle.IndraPluginPublishingExtension;
import net.kyori.indra.gradle.IndraPluginPublishingExtensionImpl;
import net.kyori.indra.internal.AbstractIndraPublishingPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

public class GradlePluginPublishingPlugin
extends AbstractIndraPublishingPlugin {
    static final boolean HAS_GRADLE_7_6 = GradleVersion.current().compareTo(GradleVersion.version((String)"7.6")) >= 0;
    private static final String EXTENSION_NAME = "indraPluginPublishing";

    protected void extraApplySteps(Project project) {
        project.getPlugins().withType(PublishPlugin.class, $ -> {
            @Nullable PluginBundleExtension pluginBundleExtension = (PluginBundleExtension)project.getExtensions().findByType(PluginBundleExtension.class);
            BiConsumer<String, String> copyProperty = (definedProperty, originalProperty) -> {
                Object property = project.findProperty(definedProperty);
                if (property != null) {
                    project.getExtensions().getExtraProperties().set(originalProperty, property);
                }
            };
            copyProperty.accept("pluginPortalApiKey", "gradle.publish.key");
            copyProperty.accept("pluginPortalApiSecret", "gradle.publish.secret");
            project.getPlugins().withType(JavaGradlePluginPlugin.class, $$ -> {
                GradlePluginDevelopmentExtension pluginDevelopment = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                IndraPluginPublishingExtensionImpl extension = (IndraPluginPublishingExtensionImpl)project.getExtensions().create(IndraPluginPublishingExtension.class, EXTENSION_NAME, IndraPluginPublishingExtensionImpl.class, new Object[]{pluginDevelopment, pluginBundleExtension});
                extension.pluginIdBase().convention(project.provider(() -> (String)project.getGroup()));
                extension.fallbackDescription.set(project.provider(() -> ((Project)project).getDescription()));
                if (HAS_GRADLE_7_6) {
                    this.applyExtensionDataModern(project, extension, pluginDevelopment);
                } else {
                    this.applyExtensionDataPreGradle76(project, extension, pluginBundleExtension);
                }
            });
        });
        project.getPlugins().withType(IndraPlugin.class, $ -> Indra.extension((ExtensionContainer)project.getExtensions()).includeJavaSoftwareComponentInPublications().set((Object)false));
    }

    private void applyExtensionDataModern(Project project, IndraPluginPublishingExtension indra, GradlePluginDevelopmentExtension extension) {
        IndraExtension indraExtension = Indra.extension((ExtensionContainer)project.getExtensions());
        extension.getVcsUrl().set(indraExtension.scm().map(SourceCodeManagement::url));
        extension.getWebsite().set(indra.website());
    }

    private void applyExtensionDataPreGradle76(Project project, IndraPluginPublishingExtension indra, PluginBundleExtension extension) {
        project.afterEvaluate(p -> {
            IndraExtension indraExtension;
            List tags;
            if (indra.bundleTags().isPresent() && !(tags = (List)indra.bundleTags().get()).isEmpty()) {
                extension.setTags((Collection)tags);
            }
            if (indra.website().isPresent()) {
                extension.setWebsite((String)indra.website().get());
            }
            if ((indraExtension = Indra.extension((ExtensionContainer)p.getExtensions())).scm().isPresent() && extension.getVcsUrl() == null) {
                extension.setVcsUrl(((SourceCodeManagement)indraExtension.scm().get()).url());
            }
            if (p.getDescription() != null && extension.getDescription() == null) {
                extension.setDescription(p.getDescription());
            }
        });
    }

    protected void applyPublishingActions(PublishingExtension extension, Set<Action<MavenPublication>> actions) {
        extension.getPublications().withType(MavenPublication.class).configureEach(publication -> {
            for (Action action : actions) {
                action.execute(publication);
            }
        });
    }

    protected void configurePublications(PublishingExtension extension, Action<MavenPublication> action) {
        extension.getPublications().withType(MavenPublication.class).configureEach(action);
    }
}

