/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.sonatype.internal;

import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusRepository;
import java.net.URI;
import javax.inject.Inject;
import net.kyori.indra.sonatype.IndraSonatypePublishingExtension;

public class IndraSonatypePublishingExtensionImpl
implements IndraSonatypePublishingExtension {
    private static final String SONATYPE_REPO = "sonatype";
    private final NexusPublishExtension nexusExtension;

    @Inject
    public IndraSonatypePublishingExtensionImpl(NexusPublishExtension nexusExtension) {
        this.nexusExtension = nexusExtension;
    }

    @Override
    public void useAlternateSonatypeOssHost(String name) {
        NexusRepository repo = (NexusRepository)this.nexusExtension.getRepositories().maybeCreate(SONATYPE_REPO);
        repo.getNexusUrl().set((Object)this.nexusUrl(name));
        repo.getSnapshotRepositoryUrl().set((Object)this.snapshotUrl(name));
    }

    private String domain(String prefix) {
        return String.format("https://%soss.sonatype.org/", prefix == null || prefix.isEmpty() ? "" : prefix + '.');
    }

    private URI nexusUrl(String prefix) {
        return URI.create(this.domain(prefix) + "service/local/");
    }

    private URI snapshotUrl(String prefix) {
        return URI.create(this.domain(prefix) + "content/repositories/snapshots/");
    }
}

