/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class Packet9Respawn
extends DefinedPacket {
    private int dimension;
    private byte difficulty;
    private byte gameMode;
    private short worldHeight;
    private String levelType;

    private Packet9Respawn() {
        super(9);
    }

    public Packet9Respawn(int dimension, byte difficulty, byte gameMode, short worldHeight, String levelType) {
        this();
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.worldHeight = worldHeight;
        this.levelType = levelType;
    }

    @Override
    public void read(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.difficulty = buf.readByte();
        this.gameMode = buf.readByte();
        this.worldHeight = buf.readShort();
        this.levelType = this.readString(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeByte((int)this.difficulty);
        buf.writeByte((int)this.gameMode);
        buf.writeShort((int)this.worldHeight);
        this.writeString(this.levelType, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Override
    public String toString() {
        return "Packet9Respawn(dimension=" + this.dimension + ", difficulty=" + this.difficulty + ", gameMode=" + this.gameMode + ", worldHeight=" + this.worldHeight + ", levelType=" + this.levelType + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet9Respawn)) {
            return false;
        }
        Packet9Respawn other = (Packet9Respawn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.difficulty != other.difficulty) {
            return false;
        }
        if (this.gameMode != other.gameMode) {
            return false;
        }
        if (this.worldHeight != other.worldHeight) {
            return false;
        }
        String this$levelType = this.levelType;
        String other$levelType = other.levelType;
        return !(this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType));
    }

    public boolean canEqual(Object other) {
        return other instanceof Packet9Respawn;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.dimension;
        result = result * 31 + this.difficulty;
        result = result * 31 + this.gameMode;
        result = result * 31 + this.worldHeight;
        String $levelType = this.levelType;
        result = result * 31 + ($levelType == null ? 0 : $levelType.hashCode());
        return result;
    }
}

