/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketC9PlayerListItem
extends DefinedPacket {
    private String username;
    private boolean online;
    private short ping;

    private PacketC9PlayerListItem() {
        super(201);
    }

    public PacketC9PlayerListItem(String username, boolean online, short ping) {
        super(201);
        this.username = username;
        this.online = online;
        this.ping = ping;
    }

    @Override
    public void read(ByteBuf buf) {
        this.username = this.readString(buf);
        this.online = buf.readBoolean();
        this.ping = buf.readShort();
    }

    @Override
    public void write(ByteBuf buf) {
        this.writeString(this.username, buf);
        buf.writeBoolean(this.online);
        buf.writeShort((int)this.ping);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isOnline() {
        return this.online;
    }

    public short getPing() {
        return this.ping;
    }

    @Override
    public String toString() {
        return "PacketC9PlayerListItem(username=" + this.getUsername() + ", online=" + this.isOnline() + ", ping=" + this.getPing() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketC9PlayerListItem)) {
            return false;
        }
        PacketC9PlayerListItem other = (PacketC9PlayerListItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (this.isOnline() != other.isOnline()) {
            return false;
        }
        return this.getPing() == other.getPing();
    }

    public boolean canEqual(Object other) {
        return other instanceof PacketC9PlayerListItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $username = this.getUsername();
        result = result * 31 + ($username == null ? 0 : $username.hashCode());
        result = result * 31 + (this.isOnline() ? 1231 : 1237);
        result = result * 31 + this.getPing();
        return result;
    }
}

