/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.combiner;

import org.spongepowered.noise.Utils;
import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;

public class Select
extends NoiseModule {
    public static final double DEFAULT_SELECT_EDGE_FALLOFF = 0.0;
    public static final double DEFAULT_SELECT_LOWER_BOUND = -1.0;
    public static final double DEFAULT_SELECT_UPPER_BOUND = 1.0;
    private double edgeFalloff = 0.0;
    private double lowerBound = -1.0;
    private double upperBound = 1.0;

    public Select() {
        super(3);
    }

    public Select(NoiseModule a, NoiseModule b, NoiseModule control) {
        this();
        this.setSourceModule(0, a);
        this.setSourceModule(1, b);
        this.setSourceModule(2, control);
    }

    public NoiseModule controlModule() {
        if (this.sourceModule == null || this.sourceModule[2] == null) {
            throw new NoModuleException(2);
        }
        return this.sourceModule[2];
    }

    public void setControlModule(NoiseModule m) {
        if (m == null) {
            throw new IllegalArgumentException("the module cannot be null");
        }
        this.sourceModule[2] = m;
    }

    public double edgeFalloff() {
        return this.edgeFalloff;
    }

    public void setEdgeFalloff(double edgeFalloff) {
        double boundSize = this.upperBound - this.lowerBound;
        this.edgeFalloff = edgeFalloff > boundSize / 2.0 ? boundSize / 2.0 : edgeFalloff;
    }

    public double lowerBound() {
        return this.lowerBound;
    }

    public double upperBound() {
        return this.upperBound;
    }

    public void setBounds(double upper, double lower) {
        if (lower > upper) {
            throw new IllegalArgumentException("lower must be less than upper");
        }
        this.lowerBound = lower;
        this.upperBound = upper;
        this.setEdgeFalloff(this.edgeFalloff);
    }

    @Override
    public double get(double x, double y, double z) {
        if (this.sourceModule[0] == null) {
            throw new NoModuleException(0);
        }
        if (this.sourceModule[1] == null) {
            throw new NoModuleException(1);
        }
        if (this.sourceModule[2] == null) {
            throw new NoModuleException(2);
        }
        double controlValue = this.sourceModule[2].get(x, y, z);
        if (this.edgeFalloff > 0.0) {
            if (controlValue < this.lowerBound - this.edgeFalloff) {
                return this.sourceModule[0].get(x, y, z);
            }
            if (controlValue < this.lowerBound + this.edgeFalloff) {
                double lowerCurve = this.lowerBound - this.edgeFalloff;
                double upperCurve = this.lowerBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceModule[0].get(x, y, z), this.sourceModule[1].get(x, y, z), alpha);
            }
            if (controlValue < this.upperBound - this.edgeFalloff) {
                return this.sourceModule[1].get(x, y, z);
            }
            if (controlValue < this.upperBound + this.edgeFalloff) {
                double lowerCurve = this.upperBound - this.edgeFalloff;
                double upperCurve = this.upperBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceModule[1].get(x, y, z), this.sourceModule[0].get(x, y, z), alpha);
            }
            return this.sourceModule[0].get(x, y, z);
        }
        if (controlValue < this.lowerBound || controlValue > this.upperBound) {
            return this.sourceModule[0].get(x, y, z);
        }
        return this.sourceModule[1].get(x, y, z);
    }
}

