/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.modifier;

import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;

public class Range
extends NoiseModule {
    public static final double DEFAULT_CURRENT_LOWER_BOUND = -1.0;
    public static final double DEFAULT_CURRENT_UPPER_BOUND = 1.0;
    public static final double DEFAULT_NEW_LOWER_BOUND = 0.0;
    public static final double DEFAULT_NEW_UPPER_BOUND = 1.0;
    private double currentLowerBound = -1.0;
    private double currentUpperBound = 1.0;
    private double newLowerBound = 0.0;
    private double newUpperBound = 1.0;
    private double scale;
    private double bias;

    public Range() {
        super(1);
    }

    public Range(NoiseModule source) {
        this();
        this.setSourceModule(0, source);
    }

    public double currentLowerBound() {
        return this.currentLowerBound;
    }

    public double currentUpperBound() {
        return this.currentUpperBound;
    }

    public double newLowerBound() {
        return this.newLowerBound;
    }

    public double newUpperBound() {
        return this.newUpperBound;
    }

    private void recalculateScaleBias() {
        this.scale = (this.newUpperBound() - this.newLowerBound()) / (this.currentUpperBound() - this.currentLowerBound());
        this.bias = this.newLowerBound() - this.currentLowerBound() * this.scale;
    }

    public void setBounds(double currentLower, double currentUpper, double newLower, double newUpper) {
        if (currentLower == currentUpper) {
            throw new IllegalArgumentException("currentLower must not equal currentUpper. Both are " + currentUpper);
        }
        if (newLower == newUpper) {
            throw new IllegalArgumentException("newLowerBound must not equal newUpperBound. Both are " + newUpper);
        }
        this.currentLowerBound = currentLower;
        this.currentUpperBound = currentUpper;
        this.newLowerBound = newLower;
        this.newUpperBound = newUpper;
        this.recalculateScaleBias();
    }

    @Override
    public double get(double x, double y, double z) {
        if (this.sourceModule[0] == null) {
            throw new NoModuleException(0);
        }
        double oldVal = this.sourceModule[0].get(x, y, z);
        return oldVal * this.scale + this.bias;
    }
}

