/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.modifier;

import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;
import org.spongepowered.noise.module.source.Perlin;

public class Turbulence
extends NoiseModule {
    public static final double DEFAULT_TURBULENCE_POWER = 1.0;
    private double power = 1.0;
    private final Perlin xDistortModule = new Perlin();
    private final Perlin yDistortModule = new Perlin();
    private final Perlin zDistortModule = new Perlin();

    public Turbulence() {
        super(1);
    }

    public Turbulence(NoiseModule source) {
        this();
        this.setSourceModule(0, source);
    }

    public double power() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public int roughnessCount() {
        return this.xDistortModule.octaveCount();
    }

    public void setRoughness(int roughness) {
        this.xDistortModule.setOctaveCount(roughness);
        this.yDistortModule.setOctaveCount(roughness);
        this.zDistortModule.setOctaveCount(roughness);
    }

    public double frequency() {
        return this.xDistortModule.frequency();
    }

    public void setFrequency(double frequency) {
        this.xDistortModule.setFrequency(frequency);
        this.yDistortModule.setFrequency(frequency);
        this.zDistortModule.setFrequency(frequency);
    }

    public int seed() {
        return this.xDistortModule.seed();
    }

    public void setSeed(int seed) {
        this.xDistortModule.setSeed(seed);
        this.yDistortModule.setSeed(seed + 1);
        this.zDistortModule.setSeed(seed + 2);
    }

    @Override
    public double get(double x, double y, double z) {
        if (this.sourceModule[0] == null) {
            throw new NoModuleException(0);
        }
        double x0 = x + 0.189422607421875;
        double y0 = y + 0.99371337890625;
        double z0 = z + 0.4781646728515625;
        double x1 = x + 0.4046478271484375;
        double y1 = y + 0.276611328125;
        double z1 = z + 0.9230499267578125;
        double x2 = x + 0.82122802734375;
        double y2 = y + 0.1710968017578125;
        double z2 = z + 0.6842803955078125;
        double xDistort = x + this.xDistortModule.get(x0, y0, z0) * this.power;
        double yDistort = y + this.yDistortModule.get(x1, y1, z1) * this.power;
        double zDistort = z + this.zDistortModule.get(x2, y2, z2) * this.power;
        return this.sourceModule[0].get(xDistort, yDistort, zDistort);
    }
}

