/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.source;

import org.spongepowered.noise.LatticeOrientation;
import org.spongepowered.noise.Noise;
import org.spongepowered.noise.NoiseQualitySimplex;
import org.spongepowered.noise.Utils;
import org.spongepowered.noise.module.NoiseModule;

public class Simplex
extends NoiseModule {
    public static final double DEFAULT_SIMPLEX_FREQUENCY = 1.0;
    public static final double DEFAULT_SIMPLEX_LACUNARITY = 2.0;
    public static final int DEFAULT_SIMPLEX_OCTAVE_COUNT = 6;
    public static final double DEFAULT_SIMPLEX_PERSISTENCE = 0.5;
    public static final LatticeOrientation DEFAULT_SIMPLEX_ORIENTATION = LatticeOrientation.XZ_BEFORE_Y;
    public static final NoiseQualitySimplex DEFAULT_SIMPLEX_QUALITY = NoiseQualitySimplex.STANDARD;
    public static final int DEFAULT_SIMPLEX_SEED = 0;
    public static final int SIMPLEX_MAX_OCTAVE = 30;
    private double frequency = 1.0;
    private double lacunarity = 2.0;
    private LatticeOrientation latticeOrientation = DEFAULT_SIMPLEX_ORIENTATION;
    private NoiseQualitySimplex noiseQuality = DEFAULT_SIMPLEX_QUALITY;
    private int octaveCount = 6;
    private double persistence = 0.5;
    private int seed = 0;

    public Simplex() {
        super(0);
    }

    public double frequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double lacunarity() {
        return this.lacunarity;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
    }

    public LatticeOrientation latticeOrientation() {
        return this.latticeOrientation;
    }

    public void setLatticeOrientation(LatticeOrientation latticeOrientation) {
        this.latticeOrientation = latticeOrientation;
    }

    public NoiseQualitySimplex noiseQuality() {
        return this.noiseQuality;
    }

    public void setNoiseQuality(NoiseQualitySimplex noiseQuality) {
        this.noiseQuality = noiseQuality;
    }

    public int octaveCount() {
        return this.octaveCount;
    }

    public void setOctaveCount(int octaveCount) {
        if (octaveCount < 1 || octaveCount > 30) {
            throw new IllegalArgumentException("octaveCount must be between 1 and MAX OCTAVE: 30");
        }
        this.octaveCount = octaveCount;
    }

    public double persistence() {
        return this.persistence;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
    }

    public int seed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public double maxValue() {
        return (Math.pow(this.persistence(), this.octaveCount()) - 1.0) / (this.persistence() - 1.0);
    }

    @Override
    public double get(double x, double y, double z) {
        double x1 = x;
        double y1 = y;
        double z1 = z;
        double value = 0.0;
        double curPersistence = 1.0;
        x1 *= this.frequency;
        y1 *= this.frequency;
        z1 *= this.frequency;
        for (int curOctave = 0; curOctave < this.octaveCount; ++curOctave) {
            double nx = Utils.makeInt32Range(x1);
            double ny = Utils.makeInt32Range(y1);
            double nz = Utils.makeInt32Range(z1);
            int seed = this.seed + curOctave;
            double signal = Noise.simplexStyleGradientCoherentNoise3D(nx, ny, nz, seed, this.latticeOrientation, this.noiseQuality);
            value += signal * curPersistence;
            x1 *= this.lacunarity;
            y1 *= this.lacunarity;
            z1 *= this.lacunarity;
            curPersistence *= this.persistence;
        }
        return value;
    }
}

