/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class Blackboard {
    private final Map<Key<Object>, Object> values = new HashMap<Key<Object>, Object>();

    public <V> V getOrCreate(Key<V> key, Supplier<? super V> defaultValue) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(defaultValue);
        return (V)((Key)key).clazz.cast(this.values.computeIfAbsent(key, k -> defaultValue.get()));
    }

    public <V> Optional<V> get(Key<V> key) {
        Objects.requireNonNull(key);
        return Optional.ofNullable(((Key)key).clazz.cast(this.values.get(key)));
    }

    public static final class Key<V>
    implements Comparable<Key<V>> {
        private final String name;
        private final Class<V> clazz;

        private Key(String name, Class<V> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public static <V> Key<V> of(String name, Class<? super V> clazz) {
            return new Key<V>(name, clazz);
        }

        public String getName() {
            return this.name;
        }

        public Class<V> getClazz() {
            return this.clazz;
        }

        @Override
        public int compareTo(Key<V> o) {
            if (this == o) {
                return 0;
            }
            return this.name.compareTo(o.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.name.equals(((Key)obj).name);
        }
    }
}

