/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.StringJoiner;

public class PluginResource {
    private final String locator;
    private final Path path;
    private FileSystem fileSystem;

    public PluginResource(String locator, Path path) {
        this.locator = locator;
        this.path = path;
    }

    public String getLocator() {
        return this.locator;
    }

    public Path getPath() {
        return this.path;
    }

    public FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = FileSystems.newFileSystem(this.getPath(), this.getClass().getClassLoader());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.fileSystem;
    }

    protected StringJoiner toStringJoiner() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("locator='" + this.locator + "'").add("path=" + this.path).add("fileSystem=" + this.fileSystem);
    }

    public String toString() {
        return this.toStringJoiner().toString();
    }
}

