/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.jvm;

import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.metadata.PluginMetadata;

public class JVMPluginContainer
implements PluginContainer {
    private final PluginCandidate<JVMPluginResource> candidate;
    private final Logger logger;
    private Object instance;

    public JVMPluginContainer(PluginCandidate<JVMPluginResource> candidate) {
        this(candidate, LogManager.getLogger((String)candidate.getMetadata().getId()));
    }

    public JVMPluginContainer(PluginCandidate<JVMPluginResource> candidate, Logger logger) {
        Objects.requireNonNull(candidate);
        Objects.requireNonNull(logger);
        this.candidate = candidate;
        this.logger = logger;
    }

    @Override
    public PluginMetadata getMetadata() {
        return this.candidate.getMetadata();
    }

    @Override
    public Path getPath() {
        return this.candidate.getResource().getPath();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    protected void setInstance(Object instance) {
        if (this.instance != null) {
            throw new RuntimeException(String.format("Attempt made to set the plugin within container '%s' twice!", this.candidate.getMetadata().getId()));
        }
        Objects.requireNonNull(instance);
        this.instance = instance;
    }

    @Override
    public Optional<URL> locateResource(URL relative) {
        ClassLoader classLoader = this.getInstance().getClass().getClassLoader();
        URL resolved = classLoader.getResource(relative.getPath());
        return Optional.ofNullable(resolved);
    }

    public int hashCode() {
        return Objects.hash(this.candidate.getMetadata().getId());
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof PluginContainer)) {
            return false;
        }
        return this.candidate.getMetadata().getId().equals(((PluginContainer)that).getMetadata().getId());
    }

    protected StringJoiner toStringJoiner() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("metadata=" + this.candidate.getMetadata()).add("path=" + this.candidate.getResource().getPath());
    }

    public String toString() {
        return this.toStringJoiner().toString();
    }
}

